
package de.fhdw.gaming.ipspiel24.fg.strategy;

import java.security.SecureRandom;
import java.util.Optional;

import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import de.fhdw.gaming.ipspiel24.fg.domain.FGState;
import de.fhdw.gaming.ipspiel24.fg.domain.FGStrategy;
import de.fhdw.gaming.ipspiel24.fg.moves.FGMove;
import de.fhdw.gaming.ipspiel24.fg.moves.factory.FGMoveFactory;

/**
 * Implements {@link FGStrategy} by always saying "no".
 */
public final class FGmixedFootballStrategy implements FGStrategy {

    /**
     * The factory for creating FG moves.
     */
    private final FGMoveFactory moveFactory;
    private final SecureRandom random;

    /**
     * Creates an {@link FGmixedFootballStrategy}.
     *
     * @param moveFactory The factory for creating FG moves.
     */
    FGmixedFootballStrategy(final FGMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
        this.random = new SecureRandom();
    }

    @Override
    public Optional<FGMove> computeNextMove(
            final int gameId,
            final FGPlayer player,
            final FGState state,
            final long maxComputationTimePerMove) {
        if (random.nextInt(3) < 2) {
            return Optional.of(this.moveFactory.createFootballMove());
        } else {
            return Optional.of(this.moveFactory.createCinemaMove());
        }
    }

    @Override
    public String toString() {
        return FGmixedFootballStrategy.class.getSimpleName();
    }
}
