package de.fhdw.gaming.ipspiel24.minimax;

import java.util.List;

import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.core.domain.Strategy;

/**
 * Interface for Game Strategy to use if minimax should be implemented.
 *
 * @param <P> Player
 * @param <S> State
 * @param <M> Move
 */
public interface MinimaxStrategy<P extends Player<P>, S extends State<P, S>, M extends Move<P, S>>
        extends Strategy<P, S, M> {

    /**
     * returns possible (and legal) moves for a given game state.
     * 
     * @param state State of the game at the current time
     */
    List<M> getPossibleMoves(S state);

    /**
     * returns a score for a given gamestate.
     *
     * @param state  current state of the game
     * @param player the player that is using minimax.
     * @param depth  depth of gametree.
     */
    int evaluate(S state, P player, int depth);

    /**
     * returns opponent of current player of gamestate.
     *
     * @param state state of the game
     */
    P getOpponent(S state);

}
