/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.impl;

import de.fhdw.gaming.core.domain.AbstractPlayer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfPlayer;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfSide;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class MuenzwurfPlayerImpl
extends AbstractPlayer<MuenzwurfPlayer>
implements MuenzwurfPlayer {
    private final Map<MuenzwurfSide, Map<MuenzwurfSide, Double>> possibleOutcomes;
    private Optional<MuenzwurfSide> answer;
    private Boolean pointsForSame;

    MuenzwurfPlayerImpl(String name, Map<MuenzwurfSide, Map<MuenzwurfSide, Double>> possibleOutcomes) {
        super(name);
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<MuenzwurfSide, Map<MuenzwurfSide, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
        this.answer = Optional.empty();
    }

    MuenzwurfPlayerImpl(MuenzwurfPlayer source) {
        super((Player)source);
        this.possibleOutcomes = source.getPossibleOutcomes();
        this.answer = source.getSide();
    }

    @Override
    public Boolean getPointsForSame() {
        return this.pointsForSame;
    }

    @Override
    public void setPointsForSame(Boolean toSet) {
        this.pointsForSame = toSet;
    }

    public String toString() {
        return String.format("MuenzwurfPlayer[name=%s, state=%s, outcome=%s, answer=%s]", this.getName(), this.getState(), this.getOutcome(), this.answer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MuenzwurfPlayerImpl) {
            MuenzwurfPlayerImpl other = (MuenzwurfPlayerImpl)obj;
            return super.equals(obj) && this.answer.equals(other.answer) && this.possibleOutcomes.equals(other.possibleOutcomes);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ Objects.hash(this.answer, this.possibleOutcomes);
    }

    @Override
    public Map<MuenzwurfSide, Map<MuenzwurfSide, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    @Override
    public Optional<MuenzwurfSide> getSide() {
        return this.answer;
    }

    @Override
    public void chooseSide(MuenzwurfSide side) throws IllegalStateException {
        if (this.answer.isPresent()) {
            throw new IllegalStateException(String.format("Player %s tried to change her answer.", this.getName()));
        }
        this.answer = Optional.of(side);
    }

    @Override
    public MuenzwurfPlayer deepCopy() {
        return new MuenzwurfPlayerImpl(this);
    }
}

