/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-Ssp.
 *
 * Ipspiel24-Ssp is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel24-Ssp is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel24-Ssp. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.ssp.domain;

import java.util.List;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.ipspiel24.ssp.moves.SspMove;

/**
 * A builder which allows to create a Ssp game.
 */
public interface SspGameBuilder extends GameBuilder {

    /**
     * Creates an {@link SspPlayerBuilder} which allows to create and add a player to the game together with her
     * strategy.
     */
    SspPlayerBuilder createPlayerBuilder();

    /**
     * Adds a player and her corresponding strategy.
     *
     * @param player   The player.
     * @param strategy The player's strategy.
     * @throws GameException if adding the player is not allowed by the rules of the game.
     */
    SspGameBuilder addPlayer(SspPlayer player, SspStrategy strategy) throws GameException;

    @Override
    SspGameBuilder addObservers(List<Observer> newObservers);

    @Override
    Game<SspPlayer, SspState, SspMove, SspStrategy> build(int id) throws GameException, InterruptedException;
}
