/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-Ssp.
 *
 * Ipspiel24-Ssp is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel24-Ssp is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel24-Ssp. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.ssp.moves.impl;

import de.fhdw.gaming.ipspiel24.ssp.moves.SspMove;
import de.fhdw.gaming.ipspiel24.ssp.moves.factory.SspMoveFactory;

/**
 * Implements {@link SspMoveFactory}.
 */
public final class SspDefaultMoveFactory implements SspMoveFactory {

    @Override
    public SspMove createRockMove() {
        return new SspRockMove();
    }

    @Override
    public SspMove createScissorsMove() {
        return new SspScissorsMove();
    }

    @Override
    public SspMove createPaperMove() {
        return new SspPaperMove();
    }
}
