/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.tictactoe.strategy.minimax;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel24.minimax.Minimax;
import de.fhdw.gaming.ipspiel24.minimax.MinimaxStrategy;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeBoard;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeFieldState;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToePlayer;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToePosition;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeRow;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeState;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeStrategy;
import de.fhdw.gaming.ipspiel24.tictactoe.core.moves.TicTacToeMove;
import de.fhdw.gaming.ipspiel24.tictactoe.core.moves.factory.TicTacToeMoveFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TicTacToeMinimaxStrategy
implements MinimaxStrategy<TicTacToePlayer, TicTacToeState, TicTacToeMove>,
TicTacToeStrategy {
    private final TicTacToeMoveFactory moveFactory;

    public TicTacToeMinimaxStrategy(TicTacToeMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<TicTacToeMove> computeNextMove(int gameId, TicTacToePlayer player, TicTacToeState state, long maxComputationTimePerMove) throws GameException, InterruptedException {
        TicTacToePlayer opponent = this.getOpponent(state);
        Minimax minimax = new Minimax((MinimaxStrategy)this, 10, (Player)opponent);
        TicTacToeMove bestMove = (TicTacToeMove)minimax.getBestMove((State)state, (Player)player);
        return Optional.of(bestMove);
    }

    public List<TicTacToeMove> getPossibleMoves(TicTacToeState state) {
        if (!state.getBoard().getRowsUniformlyMarked().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TicTacToeMove> possibleMoves = new ArrayList<TicTacToeMove>();
        TicTacToeBoard board = state.getBoard();
        Map fieldMap = board.getFieldsBeing(TicTacToeFieldState.EMPTY);
        for (Map.Entry entry : fieldMap.entrySet()) {
            possibleMoves.add(this.moveFactory.createPlaceMarkMove(state.getCurrentPlayer().isUsingCrosses(), (TicTacToePosition)entry.getKey()));
        }
        return possibleMoves;
    }

    public int evaluate(TicTacToeState state, TicTacToePlayer player, int depth) {
        TicTacToeBoard board = state.getBoard();
        Set uniformRows = board.getRowsUniformlyMarked();
        if (!uniformRows.isEmpty()) {
            TicTacToeFieldState rowState = (TicTacToeFieldState)((TicTacToeRow)uniformRows.iterator().next()).getState().orElseThrow();
            TicTacToeFieldState playerState = player.isUsingCrosses() ? TicTacToeFieldState.CROSS : TicTacToeFieldState.NOUGHT;
            int returnScore = rowState.equals((Object)playerState) ? 20 - depth : -20 + depth;
            return returnScore;
        }
        return 0;
    }

    public String toString() {
        return "TicTacToe Minimax Strategy";
    }

    public TicTacToePlayer getOpponent(TicTacToeState state) {
        System.out.println("Opponent" + (state.getCurrentPlayer() == state.getCrossesPlayer() ? state.getNoughtsPlayer() : state.getCrossesPlayer()) + " currentPLayer: " + state.getCurrentPlayer());
        return state.getCurrentPlayer() == state.getCrossesPlayer() ? state.getNoughtsPlayer() : state.getCrossesPlayer();
    }
}

