/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.othello.strategy.examples.first;

import de.fhdw.gaming.othello.core.domain.OthelloField;
import de.fhdw.gaming.othello.core.domain.OthelloFieldState;
import de.fhdw.gaming.othello.core.domain.OthelloPlayer;
import de.fhdw.gaming.othello.core.domain.OthelloState;
import de.fhdw.gaming.othello.core.domain.OthelloStrategy;
import de.fhdw.gaming.othello.core.moves.OthelloMove;
import de.fhdw.gaming.othello.core.moves.factory.OthelloMoveFactory;
import java.util.Optional;

public final class OthelloFirstMoveFoundStrategy
implements OthelloStrategy {
    private final OthelloMoveFactory moveFactory;

    OthelloFirstMoveFoundStrategy(OthelloMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<OthelloMove> computeNextMove(int gameId, OthelloPlayer player, OthelloState state) {
        boolean usingBlackTokens = player.isUsingBlackTokens();
        for (OthelloField field : state.getBoard().getFieldsBeing(OthelloFieldState.EMPTY).values()) {
            if (!field.isActive(usingBlackTokens)) continue;
            return Optional.of(this.moveFactory.createPlaceTokenMove(usingBlackTokens, field.getPosition()));
        }
        return Optional.of(this.moveFactory.createSkipMove(usingBlackTokens));
    }

    public String toString() {
        return OthelloFirstMoveFoundStrategy.class.getSimpleName();
    }
}

