/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.othello.gui.impl;

import de.fhdw.gaming.othello.core.domain.OthelloFieldState;
import java.util.ArrayList;
import java.util.Optional;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

final class OthelloFieldView
extends Region {
    private static final int FRAMES_PER_SECOND = 25;
    private static final double TOKEN_ANIMATION_RATIO = 0.5;
    private OthelloFieldState oldFieldState;
    private OthelloFieldState fieldState;
    private final Canvas canvas;
    private final ObjectProperty<Duration> moveDuration;
    private Optional<Timeline> currentAnimation;
    private boolean highlighted;

    OthelloFieldView(OthelloFieldState fieldState) {
        this.oldFieldState = fieldState;
        this.fieldState = fieldState;
        this.moveDuration = new SimpleObjectProperty((Object)Duration.millis((double)500.0));
        this.currentAnimation = Optional.empty();
        this.highlighted = false;
        this.canvas = new Canvas(){

            public boolean isResizable() {
                return true;
            }

            public double prefWidth(double height) {
                return 0.0;
            }

            public double prefHeight(double width) {
                return 0.0;
            }

            public double maxWidth(double height) {
                return Double.POSITIVE_INFINITY;
            }

            public double maxHeight(double width) {
                return Double.POSITIVE_INFINITY;
            }
        };
        this.canvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.canvas);
        this.widthProperty().addListener((observable, oldValue, newValue) -> this.draw());
        this.heightProperty().addListener((observable, oldValue, newValue) -> this.draw());
        this.setMinSize(50.0, 50.0);
        this.setMaxSize(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    ObjectProperty<Duration> moveDurationProperty() {
        return this.moveDuration;
    }

    void setFieldState(OthelloFieldState fieldState) {
        this.oldFieldState = this.fieldState;
        this.fieldState = fieldState;
        this.draw();
    }

    void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
        this.draw();
    }

    private void draw() {
        this.currentAnimation.ifPresent(Animation::stop);
        double size = this.getWidth();
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.setFill((Paint)(this.highlighted ? Color.GREEN : Color.DARKOLIVEGREEN));
        gc.fillRect(0.0, 0.0, size, size);
        gc.setFill((Paint)Color.BLACK);
        gc.beginPath();
        gc.moveTo(0.0, 0.0);
        gc.lineTo(size, 0.0);
        gc.lineTo(size, size);
        gc.lineTo(0.0, size);
        gc.lineTo(0.0, 0.0);
        gc.closePath();
        gc.stroke();
        double margin = size * 0.1;
        boolean animate = !this.oldFieldState.equals((Object)OthelloFieldState.EMPTY) && !this.oldFieldState.equals((Object)this.fieldState);
        switch (this.fieldState) {
            case EMPTY: {
                break;
            }
            case BLACK: {
                if (animate) {
                    gc.setFill((Paint)Color.WHITE);
                    gc.fillOval(margin, margin, size - 2.0 * margin, size - 2.0 * margin);
                    gc.setFill((Paint)Color.BLACK);
                    this.animateTokenChange(gc, new Rectangle2D(margin, margin, size - 2.0 * margin, size - 2.0 * margin));
                    break;
                }
                gc.setFill((Paint)Color.BLACK);
                gc.fillOval(margin, margin, size - 2.0 * margin, size - 2.0 * margin);
                break;
            }
            case WHITE: {
                if (animate) {
                    gc.setFill((Paint)Color.BLACK);
                    gc.fillOval(margin, margin, size - 2.0 * margin, size - 2.0 * margin);
                    gc.setFill((Paint)Color.WHITE);
                    this.animateTokenChange(gc, new Rectangle2D(margin, margin, size - 2.0 * margin, size - 2.0 * margin));
                    break;
                }
                gc.setFill((Paint)Color.WHITE);
                gc.fillOval(margin, margin, size - 2.0 * margin, size - 2.0 * margin);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unknown Othello field state '%s'.", this.fieldState));
            }
        }
        this.oldFieldState = this.fieldState;
    }

    private void animateTokenChange(GraphicsContext gc, Rectangle2D area) {
        Point2D centre = new Point2D(area.getMinX() + area.getWidth() / 2.0, area.getMinY() + area.getHeight() / 2.0);
        ArrayList<KeyFrame> keyFrames = new ArrayList<KeyFrame>();
        for (int keyFrameIndex = 1; keyFrameIndex < 25; ++keyFrameIndex) {
            double diffX = area.getWidth() * (double)keyFrameIndex / 25.0 / 2.0;
            double diffY = area.getHeight() * (double)keyFrameIndex / 25.0 / 2.0;
            KeyFrame keyFrame = new KeyFrame(((Duration)this.moveDuration.get()).multiply(0.5).multiply((double)keyFrameIndex).divide(25.0), event -> gc.fillOval(centre.getX() - diffX, centre.getY() - diffY, diffX * 2.0, diffY * 2.0), new KeyValue[0]);
            keyFrames.add(keyFrame);
        }
        KeyFrame finalKeyFrame = new KeyFrame(((Duration)this.moveDuration.get()).multiply(0.5), event -> gc.fillOval(area.getMinX(), area.getMinY(), area.getWidth(), area.getHeight()), new KeyValue[0]);
        keyFrames.add(finalKeyFrame);
        this.currentAnimation = Optional.of(new Timeline(keyFrames.toArray(new KeyFrame[0])));
        this.currentAnimation.get().play();
    }
}

