/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.entry;

import de.fhdw.hfp416.spaces.entry.Entry;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryReturnExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryReturnVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryVisitor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CollectionEntry
extends Entry {
    private final List<Entry> collection;
    private final Boolean isArray;
    private static final String ARRAY_PREFIX = "[L";
    private static final String ARRAY_SUFFIX = ";";
    private static final String ARRAY_SIMPLENAMESUFFIX = "[]";
    private static final Integer ARRAY_SIMPLENAMESUFFIX_LENGTH = "[]".length();

    public CollectionEntry(String name, String namespace, LinkedList<Entry> collection, Boolean isArray) {
        super(isArray != false ? name + ARRAY_SIMPLENAMESUFFIX : name, namespace);
        this.collection = Collections.unmodifiableList(new LinkedList<Entry>(collection));
        this.isArray = isArray;
    }

    public List<Entry> getCollection() {
        return this.collection;
    }

    public Boolean isArray() {
        return this.isArray;
    }

    @Override
    public String getFullQualifiedName() {
        String fullname = super.getFullQualifiedName();
        if (this.isArray.booleanValue()) {
            return ARRAY_PREFIX + fullname.substring(0, fullname.length() - ARRAY_SIMPLENAMESUFFIX_LENGTH) + ARRAY_SUFFIX;
        }
        return fullname;
    }

    @Override
    public void accept(IEntryVisitor visitor) {
        visitor.handle(this);
    }

    @Override
    public <T> T accept(IEntryReturnVisitor<T> visitor) {
        return visitor.handle(this);
    }

    @Override
    public <E extends Exception> void accept(IEntryExceptionVisitor<E> visitor) throws E {
        visitor.handle(this);
    }

    @Override
    public <T, E extends Exception> T accept(IEntryReturnExceptionVisitor<T, E> visitor) throws E {
        return visitor.handle(this);
    }
}

