/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.serialization;

import de.fhdw.hfp416.spaces.entry.CollectionEntry;
import de.fhdw.hfp416.spaces.entry.Entry;
import de.fhdw.hfp416.spaces.entry.MapEntry;
import de.fhdw.hfp416.spaces.entry.ObjectEntry;
import de.fhdw.hfp416.spaces.entry.ReferenceEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.BooleanEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.ByteEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.CharacterEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.DoubleEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.FloatEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.IntegerEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.LongEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.NullEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.ShortEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.StringEntry;
import de.fhdw.hfp416.spaces.exception.DuplicateAttributeNameException;
import de.fhdw.hfp416.spaces.exception.ReferenceAlreadySetException;
import de.fhdw.hfp416.spaces.exception.ShouldNotHappenError;
import de.fhdw.hfp416.spaces.serialization.SpaceSerializerReflectionHelper;
import de.fhdw.hfp416.spaces.serialization.visitor.ObjectReturnExceptionVisitor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.lang.model.type.NullType;

class SpaceSerializationResolver
extends ObjectReturnExceptionVisitor<Entry, DuplicateAttributeNameException> {
    private final Map<String, LinkedList<FutureEntryInformation>> entriesMappedByName = new HashMap<String, LinkedList<FutureEntryInformation>>();

    SpaceSerializationResolver() {
    }

    @Override
    public Entry handle(NullType object) {
        return new NullEntry();
    }

    @Override
    public Entry handle(Byte object) {
        return new ByteEntry(object);
    }

    @Override
    public Entry handle(Short object) {
        return new ShortEntry(object);
    }

    @Override
    public Entry handle(Integer object) {
        return new IntegerEntry(object);
    }

    @Override
    public Entry handle(Long object) {
        return new LongEntry(object);
    }

    @Override
    public Entry handle(Float object) {
        return new FloatEntry(object);
    }

    @Override
    public Entry handle(Double object) {
        return new DoubleEntry(object);
    }

    @Override
    public Entry handle(Boolean object) {
        return new BooleanEntry(object);
    }

    @Override
    public Entry handle(Character object) {
        return new CharacterEntry(object);
    }

    @Override
    public Entry handle(String object) {
        return new StringEntry(object);
    }

    @Override
    public Entry handle(Collection<?> object) throws DuplicateAttributeNameException {
        SpaceSerializerReflectionHelper.NameTuple nameTuple = SpaceSerializerReflectionHelper.getSpaceContractName(object.getClass());
        LinkedList<Entry> collection = new LinkedList<Entry>();
        for (Object item : object) {
            collection.add((Entry)this.handle(item));
        }
        return new CollectionEntry(nameTuple.getName(), nameTuple.getNamespace(), collection, false);
    }

    @Override
    public Entry handle(Object[] object) throws DuplicateAttributeNameException {
        SpaceSerializerReflectionHelper.NameTuple nameTuple = SpaceSerializerReflectionHelper.getSpaceContractName(object.getClass().getComponentType());
        LinkedList<Entry> collection = new LinkedList<Entry>();
        for (Object item : object) {
            collection.add((Entry)this.handle(item));
        }
        return new CollectionEntry(nameTuple.getName(), nameTuple.getNamespace(), collection, true);
    }

    @Override
    public Entry handle(Map<?, ?> object) throws DuplicateAttributeNameException {
        SpaceSerializerReflectionHelper.NameTuple nameTuple = SpaceSerializerReflectionHelper.getSpaceContractName(object.getClass());
        LinkedHashMap<Entry, Entry> map = new LinkedHashMap<Entry, Entry>();
        for (Map.Entry<?, ?> keyValuePair : object.entrySet()) {
            map.put((Entry)this.handle(keyValuePair.getKey()), (Entry)this.handle(keyValuePair.getValue()));
        }
        return new MapEntry(nameTuple.getName(), nameTuple.getNamespace(), map);
    }

    @Override
    public Entry elseHandle(Object object) throws DuplicateAttributeNameException {
        try {
            return this.constructObjectEntryOrReferenceEntry(object);
        }
        catch (SecurityException exception) {
            throw new ShouldNotHappenError("Unerwarteter Fehler. Der Security-Manager sollte den Zugriff per Reflection erlauben.", exception);
        }
    }

    private Entry constructObjectEntryOrReferenceEntry(Object object) throws SecurityException, DuplicateAttributeNameException {
        LinkedList<Object> entriesForName;
        Class<?> objectClass = object.getClass();
        SpaceSerializerReflectionHelper.NameTuple nameTuple = SpaceSerializerReflectionHelper.getSpaceContractName(objectClass);
        if (!this.entriesMappedByName.containsKey(nameTuple.getFullName())) {
            entriesForName = new LinkedList();
            this.entriesMappedByName.put(nameTuple.getFullName(), entriesForName);
        } else {
            entriesForName = this.entriesMappedByName.get(nameTuple.getFullName());
            for (FutureEntryInformation futureEntryInformation : entriesForName) {
                if (futureEntryInformation.object != object) continue;
                ReferenceEntry referenceEntry = new ReferenceEntry(futureEntryInformation.constructedEntry);
                if (futureEntryInformation.constructedEntry == null) {
                    futureEntryInformation.references.add(referenceEntry);
                }
                return referenceEntry;
            }
        }
        FutureEntryInformation futureEntry = new FutureEntryInformation(object, nameTuple.getName(), nameTuple.getNamespace());
        entriesForName.add(futureEntry);
        HashMap<String, Entry> hashMap = new HashMap<String, Entry>();
        for (Field field : SpaceSerializerReflectionHelper.getAllNecessaryFields(objectClass)) {
            String attributeName = field.getName();
            if (hashMap.containsKey(attributeName)) {
                throw new DuplicateAttributeNameException(String.format("The class \"%s\" contains attributes with the name \"%s\" more than once. All attribute-names should be unique per class-inheritance.", nameTuple.getFullName(), attributeName));
            }
            hashMap.put(attributeName, (Entry)this.handle(SpaceSerializerReflectionHelper.getFieldValue(field, object)));
        }
        ObjectEntry entry = new ObjectEntry(nameTuple.getName(), nameTuple.getNamespace(), hashMap);
        futureEntry.resolve(entry);
        return new ReferenceEntry(entry);
    }

    private static class FutureEntryInformation {
        private final Object object;
        private LinkedList<ReferenceEntry> references = new LinkedList();
        private ObjectEntry constructedEntry;

        private FutureEntryInformation(Object object, String name, String namespace) {
            this.object = object;
        }

        private void resolve(ObjectEntry entry) {
            this.constructedEntry = entry;
            for (ReferenceEntry referenceEntry : this.references) {
                try {
                    referenceEntry.setReference(entry);
                }
                catch (ReferenceAlreadySetException ex) {
                    throw new ShouldNotHappenError("The reference should be uninitialized.", ex);
                }
            }
        }
    }
}

