/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.serialization;

import de.fhdw.hfp416.spaces.exception.ShouldNotHappenError;
import de.fhdw.hfp416.spaces.exception.deserialization.CannotSetStaticFieldException;
import de.fhdw.hfp416.spaces.exception.deserialization.CastException;
import de.fhdw.hfp416.spaces.exception.deserialization.ClassNotFoundException;
import de.fhdw.hfp416.spaces.exception.deserialization.IllegalArgumentException;
import de.fhdw.hfp416.spaces.exception.deserialization.InstantiationException;
import de.fhdw.hfp416.spaces.exception.deserialization.InvocationTargetException;
import de.fhdw.hfp416.spaces.serialization.annotation.SpaceContract;
import de.fhdw.hfp416.spaces.serialization.annotation.SpaceContractMember;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

class SpaceSerializerReflectionHelper {
    private static final String NAMEOFTHISFIELD = "this$0";
    private static final char PACKAGE_AND_CLASSNAME_DIVIDER = '.';

    private SpaceSerializerReflectionHelper() {
    }

    static NameTuple getSpaceContractName(Class<?> clazz) {
        String namespace = clazz.getPackage().getName();
        String fullName = clazz.getName();
        String name = fullName.substring(namespace.length() + 1);
        Class<SpaceContract> annotationType = SpaceContract.class;
        if (clazz.isAnnotationPresent(annotationType)) {
            SpaceContract annotation = clazz.getAnnotation(annotationType);
            if (!annotation.name().equals("0null0")) {
                name = annotation.name();
            }
            if (!annotation.namespace().equals("0null0")) {
                namespace = annotation.namespace();
            }
            fullName = namespace + '.' + name;
        }
        return new NameTuple(name, namespace, fullName);
    }

    static String getSpaceContractMemberName(Field field) {
        SpaceContractMember annotation;
        Class<SpaceContractMember> annotationType = SpaceContractMember.class;
        if (field.isAnnotationPresent(annotationType) && !(annotation = field.getAnnotation(annotationType)).name().equals("0null0")) {
            return annotation.name();
        }
        return field.getName();
    }

    static Collection<Field> getAllNecessaryFields(Class<?> clazz) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!SpaceSerializerReflectionHelper.isNecessaryField(field)) continue;
            fields.add(field);
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz != null) {
            fields.addAll(SpaceSerializerReflectionHelper.getAllNecessaryFields(superclazz));
        }
        return fields;
    }

    private static boolean isNecessaryField(Field field) {
        int modifiers = field.getModifiers();
        return !field.getName().equals(NAMEOFTHISFIELD) && !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers);
    }

    private static void setAccessibleTrue(final AccessibleObject accessible) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                accessible.setAccessible(true);
                return null;
            }
        });
    }

    static Object getFieldValue(Field field, Object object) throws SecurityException {
        SpaceSerializerReflectionHelper.setAccessibleTrue(field);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException | java.lang.IllegalArgumentException exception) {
            throw new ShouldNotHappenError("Unerwarteter Fehler. Das Feld sollte existieren.", exception);
        }
    }

    static Class<?> loadClass(String fullname) throws ClassNotFoundException {
        try {
            return Class.forName(fullname);
        }
        catch (java.lang.ClassNotFoundException ex) {
            throw new ClassNotFoundException(ex);
        }
    }

    static <T> T createObject(Class<T> clazz) throws de.fhdw.hfp416.spaces.exception.deserialization.NoSuchMethodException, InstantiationException, InvocationTargetException, SecurityException {
        try {
            return SpaceSerializerReflectionHelper.createObjectInternal(clazz);
        }
        catch (NoSuchMethodException ex) {
            throw new de.fhdw.hfp416.spaces.exception.deserialization.NoSuchMethodException(ex);
        }
        catch (java.lang.InstantiationException ex) {
            throw new InstantiationException(ex);
        }
        catch (java.lang.reflect.InvocationTargetException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (IllegalAccessException | java.lang.IllegalArgumentException exception) {
            throw new ShouldNotHappenError("Unerwarteter Fehler. Der Zugriff sollte m\u00f6glich sein und die Parameter sollten zum default Constructor passen.", exception);
        }
    }

    private static <T> T createObjectInternal(Class<T> clazz) throws NoSuchMethodException, java.lang.InstantiationException, java.lang.reflect.InvocationTargetException, SecurityException, IllegalAccessException, java.lang.IllegalArgumentException {
        Class<?> outerClazz = clazz.getDeclaringClass();
        if (outerClazz == null || Modifier.isStatic(clazz.getModifiers())) {
            return SpaceSerializerReflectionHelper.createOuterObject(clazz);
        }
        return SpaceSerializerReflectionHelper.createInnerObject(clazz, outerClazz);
    }

    private static <T> T createInnerObject(Class<T> clazz, Class<?> outerClazz) throws NoSuchMethodException, java.lang.InstantiationException, java.lang.reflect.InvocationTargetException, SecurityException, IllegalAccessException, java.lang.IllegalArgumentException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(outerClazz);
        SpaceSerializerReflectionHelper.setAccessibleTrue(constructor);
        return constructor.newInstance(SpaceSerializerReflectionHelper.createObjectInternal(outerClazz));
    }

    private static <T> T createOuterObject(Class<T> clazz) throws NoSuchMethodException, java.lang.InstantiationException, java.lang.reflect.InvocationTargetException, SecurityException, IllegalAccessException, java.lang.IllegalArgumentException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        SpaceSerializerReflectionHelper.setAccessibleTrue(constructor);
        return constructor.newInstance(new Object[0]);
    }

    static void setFieldValue(Field field, Object object, Object value) throws IllegalArgumentException, CastException, CannotSetStaticFieldException {
        SpaceSerializerReflectionHelper.setAccessibleTrue(field);
        try {
            SpaceSerializerReflectionHelper.setField(field, object, value);
        }
        catch (java.lang.IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IllegalAccessException exception) {
            throw new CannotSetStaticFieldException(exception);
        }
    }

    private static void setField(Field field, Object object, Object value) throws java.lang.IllegalArgumentException, IllegalAccessException, CastException {
        Class<?> fieldType = field.getType();
        Object castedValue = SpaceSerializerReflectionHelper.castValue(fieldType, value);
        field.set(object, castedValue);
    }

    private static Object castValue(Class<?> targetType, Object value) throws CastException {
        if (value == null) {
            return null;
        }
        if (targetType.isInstance(value)) {
            return value;
        }
        if (value instanceof Boolean && Boolean.TYPE.equals(targetType)) {
            return value;
        }
        if (value instanceof Character && Character.TYPE.equals(targetType)) {
            return value;
        }
        if (value instanceof Number) {
            Number castedValue = (Number)value;
            if (value instanceof Float && Float.TYPE.equals(targetType)) {
                return Float.valueOf(castedValue.floatValue());
            }
            if (value instanceof Double && Double.TYPE.equals(targetType)) {
                return castedValue.doubleValue();
            }
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                if (Byte.class.equals(targetType) || Byte.TYPE.equals(targetType)) {
                    return castedValue.byteValue();
                }
                if (Short.class.equals(targetType) || Short.TYPE.equals(targetType)) {
                    return castedValue.shortValue();
                }
                if (Integer.class.equals(targetType) || Integer.TYPE.equals(targetType)) {
                    return castedValue.intValue();
                }
                if (Long.class.equals(targetType) || Long.TYPE.equals(targetType)) {
                    return castedValue.longValue();
                }
            }
            throw new CastException(String.format("Casting and setting a %s to a %s Field would lead to unprecise values.", value.getClass(), targetType));
        }
        if (value.getClass().isArray()) {
            return SpaceSerializerReflectionHelper.castArray(targetType, (Object[])value);
        }
        if (value instanceof Map) {
            return value;
        }
        throw new CastException(String.format("Casting and setting a %s to a %s Field is not possible.", value.getClass(), targetType));
    }

    static Object castArray(Class<?> targetType, Object[] array) throws CastException {
        Class<?> targetComponentType = targetType.getComponentType();
        Object castedValue = Array.newInstance(targetComponentType, array.length);
        for (int index = 0; index < array.length; ++index) {
            Object item = SpaceSerializerReflectionHelper.castValue(targetComponentType, array[index]);
            Array.set(castedValue, index, item);
        }
        return castedValue;
    }

    static class NameTuple {
        private final String name;
        private final String namespace;
        private final String fullName;

        private NameTuple(String name, String namespace, String fullName) {
            this.name = name;
            this.namespace = namespace;
            this.fullName = fullName;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

