/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.entry;

import de.fhdw.hfp416.spaces.entry.Entry;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryReturnExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryReturnVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryVisitor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ObjectEntry
extends Entry {
    private final Map<String, Entry> attributes;

    public ObjectEntry(String name, String namespace, Map<String, Entry> attributes) {
        super(name, namespace);
        this.attributes = Collections.unmodifiableMap(new LinkedHashMap<String, Entry>(attributes));
    }

    public Map<String, Entry> getAttributes() {
        return this.attributes;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectEntry other = (ObjectEntry)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public String toString() {
        return "ObjectEntry [attributes=" + this.attributes + ", getName()=" + this.getName() + ", getNamespace()=" + this.getNamespace() + "]";
    }

    @Override
    public void accept(IEntryVisitor visitor) {
        visitor.handle(this);
    }

    @Override
    public <T> T accept(IEntryReturnVisitor<T> visitor) {
        return visitor.handle(this);
    }

    @Override
    public <E extends Exception> void accept(IEntryExceptionVisitor<E> visitor) throws E {
        visitor.handle(this);
    }

    @Override
    public <T, E extends Exception> T accept(IEntryReturnExceptionVisitor<T, E> visitor) throws E {
        return visitor.handle(this);
    }
}

