/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.template;

import de.fhdw.hfp416.spaces.entry.CollectionEntry;
import de.fhdw.hfp416.spaces.entry.Entry;
import de.fhdw.hfp416.spaces.entry.visitor.EntryReturnDefaultVisitor;
import de.fhdw.hfp416.spaces.template.Template;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class OrTemplate
extends Template {
    private Collection<Template> templates;

    public OrTemplate(String name, String namespace, Collection<Template> templates) {
        super(name, namespace);
        this.templates = templates;
    }

    public OrTemplate(String name, String namespace) {
        this(name, namespace, new ArrayList<Template>());
    }

    public OrTemplate(Collection<Template> templates) {
        this.templates = templates;
    }

    public OrTemplate() {
        this(new ArrayList<Template>());
    }

    public void add(Template template) {
        this.getTemplates().add(template);
    }

    @Override
    protected boolean matchNameAndNamespace(Entry entry) {
        return true;
    }

    protected boolean matchSingleEntry(Entry entry) {
        for (Template current : this.getTemplates()) {
            if (!current.match(entry)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean matchAttributes(Entry entry, Map<Template, Entry> alreadyCheckedEntries) {
        return entry.accept(new EntryReturnDefaultVisitor<Boolean>(){

            @Override
            public Boolean handle(CollectionEntry entry) {
                for (Entry currentEntry : entry.getCollection()) {
                    boolean entryFitsToAtleastOneTemplate = OrTemplate.this.matchSingleEntry(currentEntry);
                    if (entryFitsToAtleastOneTemplate) continue;
                    return false;
                }
                return true;
            }

            @Override
            protected Boolean defaultHandle(Entry entry) {
                return OrTemplate.this.matchSingleEntry(entry);
            }
        });
    }

    public Collection<Template> getTemplates() {
        return this.templates;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getTemplates() == null ? 0 : this.getTemplates().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrTemplate other = (OrTemplate)obj;
        return !(this.getTemplates() == null ? other.getTemplates() != null : !this.getTemplates().equals(other.getTemplates()));
    }

    public String toString() {
        return "OrTemplate [templates=" + this.templates + "]";
    }
}

