/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.entry;

import de.fhdw.hfp416.spaces.entry.visitor.IEntryExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryReturnExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryReturnVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryVisitor;

public abstract class Entry {
    private static final char PACKAGE_AND_CLASSNAME_DIVIDER = '.';
    private final String name;
    private final String namespace;

    public Entry(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFullQualifiedName() {
        return this.getNamespace() + '.' + this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entry other = (Entry)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getNamespace() == null ? other.getNamespace() != null : !this.getNamespace().equals(other.getNamespace()));
    }

    public abstract void accept(IEntryVisitor var1);

    public abstract <T> T accept(IEntryReturnVisitor<T> var1);

    public abstract <E extends Exception> void accept(IEntryExceptionVisitor<E> var1) throws E;

    public abstract <T, E extends Exception> T accept(IEntryReturnExceptionVisitor<T, E> var1) throws E;
}

