/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.entry.primitiveentry;

import de.fhdw.hfp416.spaces.entry.primitiveentry.PrimitiveEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.visitor.IPrimitiveEntryExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.primitiveentry.visitor.IPrimitiveEntryReturnExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.primitiveentry.visitor.IPrimitiveEntryReturnVisitor;
import de.fhdw.hfp416.spaces.entry.primitiveentry.visitor.IPrimitiveEntryVisitor;

public class DoubleEntry
extends PrimitiveEntry<Double> {
    private static final String DOUBLE_NAME = Double.class.getSimpleName();
    private static final String DOUBLE_NAMESPACE = Double.class.getPackage().getName();
    private final Double value;

    public DoubleEntry(Double value) {
        super(DOUBLE_NAME, DOUBLE_NAMESPACE);
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleEntry other = (DoubleEntry)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "DoubleEntry [value=" + this.value + "]";
    }

    @Override
    public void accept(IPrimitiveEntryVisitor visitor) {
        visitor.handle(this);
    }

    @Override
    public <T> T accept(IPrimitiveEntryReturnVisitor<T> visitor) {
        return visitor.handle(this);
    }

    @Override
    public <E extends Exception> void accept(IPrimitiveEntryExceptionVisitor<E> visitor) throws E {
        visitor.handle(this);
    }

    @Override
    public <T, E extends Exception> T accept(IPrimitiveEntryReturnExceptionVisitor<T, E> visitor) throws E {
        return visitor.handle(this);
    }
}

