/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.entry.primitiveentry;

import de.fhdw.hfp416.spaces.entry.primitiveentry.PrimitiveEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.visitor.IPrimitiveEntryExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.primitiveentry.visitor.IPrimitiveEntryReturnExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.primitiveentry.visitor.IPrimitiveEntryReturnVisitor;
import de.fhdw.hfp416.spaces.entry.primitiveentry.visitor.IPrimitiveEntryVisitor;

public class FloatEntry
extends PrimitiveEntry<Float> {
    private static final String FLOAT_NAME = Float.class.getSimpleName();
    private static final String FLOAT_NAMESPACE = Float.class.getPackage().getName();
    private final Float value;

    public FloatEntry(Float value) {
        super(FLOAT_NAME, FLOAT_NAMESPACE);
        this.value = value;
    }

    @Override
    public Float getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatEntry other = (FloatEntry)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "FloatEntry [value=" + this.value + "]";
    }

    @Override
    public void accept(IPrimitiveEntryVisitor visitor) {
        visitor.handle(this);
    }

    @Override
    public <T> T accept(IPrimitiveEntryReturnVisitor<T> visitor) {
        return visitor.handle(this);
    }

    @Override
    public <E extends Exception> void accept(IPrimitiveEntryExceptionVisitor<E> visitor) throws E {
        visitor.handle(this);
    }

    @Override
    public <T, E extends Exception> T accept(IPrimitiveEntryReturnExceptionVisitor<T, E> visitor) throws E {
        return visitor.handle(this);
    }
}

