/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces;

import de.fhdw.hfp416.spaces.EntryId;
import de.fhdw.hfp416.spaces.SpaceStore;
import de.fhdw.hfp416.spaces.access.ReadAccess;
import de.fhdw.hfp416.spaces.access.TakeAccess;
import de.fhdw.hfp416.spaces.access.TemplateAccess;
import de.fhdw.hfp416.spaces.access.WriteAccess;
import de.fhdw.hfp416.spaces.accessrequest.AccessRequest;
import de.fhdw.hfp416.spaces.accessrequest.AccessRequestVisitor;
import de.fhdw.hfp416.spaces.accessrequest.GetMetaInfoAccessRequest;
import de.fhdw.hfp416.spaces.accessrequest.ReadAccessRequest;
import de.fhdw.hfp416.spaces.accessrequest.TakeAccessRequest;
import de.fhdw.hfp416.spaces.accessrequest.TemplateAccessRequest;
import de.fhdw.hfp416.spaces.accessrequest.TemplateAccessRequestReturnVisitor;
import de.fhdw.hfp416.spaces.accessrequest.TimespanAccessRequest;
import de.fhdw.hfp416.spaces.accessrequest.WriteAccessRequest;
import de.fhdw.hfp416.spaces.exception.NoMetaInfoFoundException;
import de.fhdw.hfp416.spaces.remoteentry.EntryMetaInfo;
import de.fhdw.hfp416.spaces.time.timepoint.Timepoint;
import java.time.Instant;
import java.util.concurrent.BlockingQueue;

public class SpaceService
implements Runnable,
AccessRequestVisitor {
    private int idCounter;
    private final BlockingQueue<AccessRequest<?>> requests;
    private final SpaceStore store;

    public SpaceService(BlockingQueue<AccessRequest<?>> requests) {
        this.requests = requests;
        this.store = new SpaceStore();
    }

    public void start() {
        new Thread(this).start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.requests.take().accept(this);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public void handle(WriteAccessRequest request) {
        Timepoint timepoint = this.calcTimepoint(request);
        WriteAccess access = new WriteAccess(timepoint, request.getEntry(), request.getFutureMetaInfo(), this.fetchNextEntryId());
        this.store.write(access);
        request.getReturnFuture().set(access.getEntryId());
    }

    @Override
    public void handle(TemplateAccessRequest request) {
        final Timepoint timepoint = this.calcTimepoint(request);
        request.getReturnFuture().setExpireTimepoint(timepoint);
        TemplateAccess access = request.accept(new TemplateAccessRequestReturnVisitor<TemplateAccess>(){

            @Override
            public TemplateAccess handle(ReadAccessRequest request) {
                return new ReadAccess(timepoint, request.getTemplate(), request.getReturnFuture());
            }

            @Override
            public TemplateAccess handle(TakeAccessRequest request) {
                return new TakeAccess(timepoint, request.getTemplate(), request.getReturnFuture());
            }
        });
        this.store.readOrTake(access);
    }

    @Override
    public void handle(GetMetaInfoAccessRequest request) {
        EntryMetaInfo metaInfo;
        try {
            metaInfo = this.store.getEntryMetaInfo(request.getEntryId());
        }
        catch (NoMetaInfoFoundException ex) {
            request.getReturnFuture().abort();
            return;
        }
        request.getReturnFuture().set(metaInfo);
    }

    private Timepoint calcTimepoint(TimespanAccessRequest<?> request) {
        return Timepoint.create(Instant.now(), request.getTimespan());
    }

    private EntryId fetchNextEntryId() {
        return new EntryId(this.idCounter++);
    }
}

