/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.remoteentry;

import de.fhdw.hfp416.spaces.exception.NoMetaInfoFoundException;
import de.fhdw.hfp416.spaces.remoteentry.EntryMetaInfo;
import de.fhdw.hfp416.spaces.remoteentry.EntryNotInSpaceRemoteEntryState;
import de.fhdw.hfp416.spaces.remoteentry.RemoteEntry;
import de.fhdw.hfp416.spaces.remoteentry.RemoteEntryState;
import de.fhdw.hfp416.spaces.remoteentry.info.DeadBcTakenEntryInfo;
import de.fhdw.hfp416.spaces.remoteentry.info.DeadBcTimeoutEntryInfo;
import de.fhdw.hfp416.spaces.remoteentry.info.EntryInfoVisitor;
import de.fhdw.hfp416.spaces.remoteentry.info.LivingEntryInfo;
import de.fhdw.hfp416.spaces.util.future.FutureReturnrequestAbortedException;
import java.util.NoSuchElementException;

public class EntryInSpaceRemoteEntryState
extends RemoteEntryState {
    public EntryInSpaceRemoteEntryState(RemoteEntry remoteEntry) {
        super(remoteEntry);
    }

    @Override
    public EntryMetaInfo getMetaInfo() {
        EntryMetaInfo info;
        try {
            info = this.getRemoteEntry().getFutureMetaInfo().getWithoutBlocking();
        }
        catch (NoSuchElementException ex) {
            try {
                info = this.getRemoteEntry().getSpace().getEntryMetaInfo(this.getRemoteEntry().getId());
            }
            catch (NoMetaInfoFoundException exx) {
                throw new Error(exx);
            }
        }
        catch (FutureReturnrequestAbortedException ex) {
            throw new Error(ex);
        }
        final EntryMetaInfo metaInfo = info;
        metaInfo.getEntryInfo().accept(new EntryInfoVisitor(){

            @Override
            public void handle(DeadBcTakenEntryInfo info) {
                EntryInSpaceRemoteEntryState.this.switchToDead(metaInfo);
            }

            @Override
            public void handle(DeadBcTimeoutEntryInfo info) {
                EntryInSpaceRemoteEntryState.this.switchToDead(metaInfo);
            }

            @Override
            public void handle(LivingEntryInfo info) {
            }
        });
        return metaInfo;
    }

    private void switchToDead(EntryMetaInfo metaInfo) {
        this.getRemoteEntry().setState(new EntryNotInSpaceRemoteEntryState(this.getRemoteEntry(), metaInfo));
    }
}

