/*
 * Decompiled with CFR 0.152.
 */
package auftraege.factory;

import auftraege.auftragsBildungsParameter.SendungsAnzahlSpanne;
import auftraege.factory.DirectVoraussichtlicheDokumentenklassenVariablenFactory;
import java.util.regex.Matcher;
import util.RegexConstants;

public enum SendungsanzahlSpanneFactory implements DirectVoraussichtlicheDokumentenklassenVariablenFactory<SendungsAnzahlSpanne>
{
    INSTANCE;


    @Override
    public SendungsAnzahlSpanne parse(String wert) {
        Matcher zwischenZweiZahlenMatcher = RegexConstants.ZWISCHEN_ZWEI_ZAHLEN.matcher(wert);
        Matcher vergleichsoperatorMitZahlMatcher = RegexConstants.VERGLEICHS_OPERATOR_MIT_ZAHL.matcher(wert);
        Matcher nurZahlMatcher = RegexConstants.ZAHL.matcher(wert);
        if (vergleichsoperatorMitZahlMatcher.find()) {
            switch (vergleichsoperatorMitZahlMatcher.group(1)) {
                case "<": {
                    return new SendungsAnzahlSpanne(0, Integer.parseInt(vergleichsoperatorMitZahlMatcher.group(2)));
                }
                case ">": {
                    return new SendungsAnzahlSpanne(Integer.parseInt(vergleichsoperatorMitZahlMatcher.group(2)) + 1, Integer.MAX_VALUE);
                }
                case "<=": {
                    return new SendungsAnzahlSpanne(0, Integer.parseInt(vergleichsoperatorMitZahlMatcher.group(2)) + 1);
                }
                case ">=": {
                    return new SendungsAnzahlSpanne(Integer.parseInt(vergleichsoperatorMitZahlMatcher.group(2)), Integer.MAX_VALUE);
                }
            }
        } else {
            if (zwischenZweiZahlenMatcher.find()) {
                return new SendungsAnzahlSpanne(Integer.parseInt(zwischenZweiZahlenMatcher.group(1)), Integer.parseInt(zwischenZweiZahlenMatcher.group(2)) + 1);
            }
            if (nurZahlMatcher.matches()) {
                int zahl = Integer.parseInt(nurZahlMatcher.group(1));
                return new SendungsAnzahlSpanne(zahl, zahl);
            }
        }
        throw new IllegalArgumentException("Der Wert [ " + wert + " ] der Blattanzahl matcht auf keines der vorgegebenen Pattern.");
    }
}

