/*
 * Decompiled with CFR 0.152.
 */
package maschine.faehigkeit;

import java.util.EnumSet;
import maschine.faehigkeit.DruckTyp;
import maschine.faehigkeit.FaehigkeitVisitor;
import maschine.faehigkeit.FarbDruckTyp;
import maschine.faehigkeit.Kuvertieren;
import maschine.faehigkeit.MaschinenFaehigkeit;
import maschine.faehigkeit.SimplesDrucken;
import maschine.faehigkeit.SimplesKuvertieren;
import maschine.papierart.PapierQuelle;

public class Drucken
extends SimplesDrucken {
    private final PapierQuelle unterstuetztePapierQuellen;
    private final EnumSet<FarbDruckTyp> unterstuetzteFarbdruckTypen;
    private final EnumSet<DruckTyp> unterstuetzteDrucktypen;

    public Drucken(String name, PapierQuelle papierQuelle, EnumSet<FarbDruckTyp> farbeOderSW, EnumSet<DruckTyp> druckTyp) {
        super(name);
        this.unterstuetztePapierQuellen = papierQuelle;
        this.unterstuetzteFarbdruckTypen = farbeOderSW;
        this.unterstuetzteDrucktypen = druckTyp;
    }

    public boolean supports(PapierQuelle papierQuelle) {
        return this.unterstuetztePapierQuellen == papierQuelle;
    }

    public boolean supports(FarbDruckTyp farbDruckTyp) {
        return this.unterstuetzteFarbdruckTypen.contains(farbDruckTyp);
    }

    public boolean supports(DruckTyp druckTyp) {
        return this.unterstuetzteDrucktypen.contains(druckTyp);
    }

    @Override
    public boolean erfuelltDruckTyp(DruckTyp drucktyp) {
        return this.unterstuetzteDrucktypen.contains(drucktyp);
    }

    @Override
    public boolean erfuelltFarbDruckTyp(FarbDruckTyp farbdrucktyp) {
        return this.unterstuetzteFarbdruckTypen.contains(farbdrucktyp);
    }

    @Override
    public boolean erfuellt(MaschinenFaehigkeit anforderung) {
        return anforderung.accept(new FaehigkeitVisitor<Boolean>(){

            @Override
            public Boolean handle(Drucken drucken) {
                return Drucken.this.unterstuetzteDrucktypen.containsAll(drucken.unterstuetzteDrucktypen) && Drucken.this.unterstuetzteFarbdruckTypen.containsAll(drucken.unterstuetzteFarbdruckTypen) && Drucken.this.unterstuetztePapierQuellen.compareTo(drucken.unterstuetztePapierQuellen) >= 0;
            }

            @Override
            public Boolean handle(Kuvertieren kuvertieren) {
                return false;
            }

            @Override
            public Boolean handle(SimplesDrucken simplesDrucken) {
                return true;
            }

            @Override
            public Boolean handle(SimplesKuvertieren simplesKuvertieren) {
                return false;
            }
        });
    }

    @Override
    public <T> T accept(FaehigkeitVisitor<T> visitor) {
        return visitor.handle(this);
    }

    public EnumSet<FarbDruckTyp> getUnterstuetzteFarbdruckTypen() {
        return this.unterstuetzteFarbdruckTypen;
    }

    public EnumSet<DruckTyp> getUnterstuetzteDrucktypen() {
        return this.unterstuetzteDrucktypen;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unterstuetzteDrucktypen == null ? 0 : this.unterstuetzteDrucktypen.hashCode());
        result = 31 * result + (this.unterstuetzteFarbdruckTypen == null ? 0 : this.unterstuetzteFarbdruckTypen.hashCode());
        result = 31 * result + (this.unterstuetztePapierQuellen == null ? 0 : this.unterstuetztePapierQuellen.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SimplesDrucken && !(obj instanceof Drucken)) {
            return false;
        }
        if (obj instanceof Drucken) {
            Drucken other = (Drucken)obj;
            return this.unterstuetzteDrucktypen.equals(other.unterstuetzteDrucktypen) && this.unterstuetzteFarbdruckTypen.equals(other.unterstuetzteFarbdruckTypen) && this.unterstuetztePapierQuellen.equals((Object)other.unterstuetztePapierQuellen);
        }
        return false;
    }
}

