/*
 * Decompiled with CFR 0.152.
 */
package planung;

import maschine.faehigkeit.Drucken;
import maschine.faehigkeit.FaehigkeitVisitor;
import maschine.faehigkeit.Kuvertieren;
import maschine.faehigkeit.MaschinenFaehigkeit;
import maschine.faehigkeit.SimplesDrucken;
import maschine.faehigkeit.SimplesKuvertieren;

public enum Begruendung {
    AlleSchichtenVoll("Alle Schichten voll"),
    SLAVerpennt("SLA verpennt"),
    KannNichtDrucken("kann nicht gedruckt werden"),
    KannNichtKuvertieren("kann nicht kuvertiert werden");

    private final String text;

    private Begruendung(String text) {
        this.text = text;
    }

    public static Begruendung erstelleBegruendungFuerFaehigkeit(MaschinenFaehigkeit faehigkeit) {
        return faehigkeit.accept(new FaehigkeitVisitor<Begruendung>(){

            @Override
            public Begruendung handle(Drucken drucken) {
                return KannNichtDrucken;
            }

            @Override
            public Begruendung handle(Kuvertieren kuvertieren) {
                return KannNichtKuvertieren;
            }

            @Override
            public Begruendung handle(SimplesDrucken simplesDrucken) {
                return KannNichtDrucken;
            }

            @Override
            public Begruendung handle(SimplesKuvertieren simplesKuvertieren) {
                return KannNichtKuvertieren;
            }
        });
    }

    public String getText() {
        return this.text;
    }
}

