/*
 * Decompiled with CFR 0.152.
 */
package schnittstelle;

import ablaeufe.meta.Prozesstyp;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import maschine.Maschine;
import mensch.Mitarbeiter;
import mensch.Produktionsrolle;
import mensch.Qualifikation;
import mensch.faehigkeit.MitarbeiterFaehigkeit;
import mensch.faehigkeit.MitarbeiterFaehigkeitenManager;
import persist.Persistierer;
import schnittstelle.ablaeufeKommandos.ErstelleKommandos.ErstelleAbstraktionstypKommandoMitResultat;
import schnittstelle.ablaeufeKommandos.ErstelleKommandos.ErstelleAlternativetypKommandoMitResultat;
import schnittstelle.ablaeufeKommandos.ErstelleKommandos.ErstelleEndeaktivitaetstypKommandoMitResultat;
import schnittstelle.ablaeufeKommandos.ErstelleKommandos.ErstelleStandardaktivitaetstypKommandoMitResultat;
import schnittstelle.ablaeufeKommandos.ErstelleKommandos.ErstelleStartaktivitaetstypKommandoMitResultat;
import schnittstelle.ablaeufeKommandos.ErstelleKommandos.ErstelleSynchronisationstypKommandoMitResultat;
import schnittstelle.ablaeufeKommandos.ErstelleKommandos.ErstelleVerteilungstypKommandoMitResultat;
import schnittstelle.ablaeufeKommandos.ErstelleKommandos.ErstelleZusammengesetzterProzesstypKommandoMitResultat;
import schnittstelle.kommandoArchitektur.Kommando;
import schnittstelle.kommandoArchitektur.KommandoVisitor;
import schnittstelle.maschinenKommandos.ErstelleMaschineKommandoMitResultat;
import schnittstelle.mitarbeiterKommandos.ErstelleMitarbeiterFaehigkeitKommando;
import schnittstelle.mitarbeiterKommandos.ErstelleMitarbeiterKommandoMitResultat;
import schnittstelle.mitarbeiterKommandos.ErstelleProduktionsrolleKommandoMitResultat;
import schnittstelle.mitarbeiterKommandos.ErstelleQualifikationKommandoMitResultat;
import schnittstelle.mitarbeiterKommandos.FuegeFaehigkeitZuProduktionsrolleHinzuKommando;
import schnittstelle.mitarbeiterKommandos.FuegeProduktionsrolleZuMitarbeiterHinzuKommando;
import schnittstelle.mitarbeiterKommandos.FuegeQualifikationZuMitarbeiterHinzuKommando;
import util.exceptions.PPSException;
import util.exceptions.SitzungsException;

public final class Sitzung {
    private static Sitzung instance;
    private MitarbeiterFaehigkeitenManager mitarbeiterFaehigkeitenManager;
    private int id = 0;
    private final transient List<Kommando> erstellteKommandos = new ArrayList<Kommando>();
    private final Collection<Maschine> maschinen = new ArrayList<Maschine>();
    private final Collection<MitarbeiterFaehigkeit> mitarbeiterFaehigkeiten = new ArrayList<MitarbeiterFaehigkeit>();
    private final Collection<Qualifikation> qualifikationen = new ArrayList<Qualifikation>();
    private final Collection<Mitarbeiter> mitarbeiter = new ArrayList<Mitarbeiter>();
    private final Collection<Produktionsrolle> produktionsrollen = new ArrayList<Produktionsrolle>();
    private final Collection<Prozesstyp> prozesse = new ArrayList<Prozesstyp>();

    private Sitzung() {
    }

    public static synchronized Sitzung getInstance() {
        if (null == instance) {
            instance = new Sitzung();
        }
        return instance;
    }

    public int getUniqueId() {
        return this.id++;
    }

    public void addKommando(Kommando kommando) {
        this.getErstellteKommandos().add(kommando);
    }

    public boolean contains(Kommando kommando) {
        return this.getErstellteKommandos().contains(kommando);
    }

    public void speichereSitzung(File speicherort) throws IOException {
        Persistierer.persistiere((Object)this, (File)speicherort);
    }

    public static synchronized Sitzung ladeSitzung(File speicherort) throws SitzungsException {
        if (instance != null) {
            throw new SitzungsException("Es existiert bereits eine Sitzung!");
        }
        instance = (Sitzung)Persistierer.lade((File)speicherort);
        return instance;
    }

    public static void loescheSitzung() {
        instance = null;
    }

    List<Kommando> getErstellteKommandos() {
        return this.erstellteKommandos;
    }

    public Collection<Mitarbeiter> getErstellteMitarbeiter() {
        return this.mitarbeiter;
    }

    public Collection<Maschine> getErstellteMaschinen() {
        return this.maschinen;
    }

    public Collection<MitarbeiterFaehigkeit> getErstellteMitarbeiterFaehigkeiten() {
        return this.mitarbeiterFaehigkeiten;
    }

    public void notifyKommandoAusgefuehrt(Kommando kommando) {
        try {
            kommando.accept(new KommandoVisitorImplementierung());
        }
        catch (PPSException e) {
            e.printStackTrace();
        }
    }

    public MitarbeiterFaehigkeitenManager getMitarbeiterFaehigkeitenManager() {
        return this.mitarbeiterFaehigkeitenManager;
    }

    public void provideMitarbeiterFaehigkeitenManager(MitarbeiterFaehigkeitenManager neuerMitarbeiterFaehigkeitenManager) {
        if (this.mitarbeiterFaehigkeitenManager != null) {
            throw new Error("darf nur aufgerufen werden, wenn die Instanz zuvor nicht belegt ist.");
        }
        this.mitarbeiterFaehigkeitenManager = neuerMitarbeiterFaehigkeitenManager;
    }

    private final class KommandoVisitorImplementierung
    implements KommandoVisitor {
        private KommandoVisitorImplementierung() {
        }

        @Override
        public void handle(ErstelleZusammengesetzterProzesstypKommandoMitResultat erstelleZusammengesetzterProzesstypKommando) {
            Sitzung.this.prozesse.add(erstelleZusammengesetzterProzesstypKommando.getResultat());
        }

        @Override
        public void handle(ErstelleAbstraktionstypKommandoMitResultat erstelleAbstraktionstypKommando) {
            Sitzung.this.prozesse.add(erstelleAbstraktionstypKommando.getResultat());
        }

        @Override
        public void handle(ErstelleAlternativetypKommandoMitResultat erstelleAlternativetypKommando) {
            Sitzung.this.prozesse.add(erstelleAlternativetypKommando.getResultat());
        }

        @Override
        public void handle(ErstelleEndeaktivitaetstypKommandoMitResultat erstelleEndeaktivitaetstypKommando) {
            Sitzung.this.prozesse.add(erstelleEndeaktivitaetstypKommando.getResultat());
        }

        @Override
        public void handle(ErstelleStandardaktivitaetstypKommandoMitResultat erstelleStandardaktivitaetstypKommando) {
            Sitzung.this.prozesse.add(erstelleStandardaktivitaetstypKommando.getResultat());
        }

        @Override
        public void handle(ErstelleStartaktivitaetstypKommandoMitResultat erstelleStartaktivitaetstypKommando) {
            Sitzung.this.prozesse.add(erstelleStartaktivitaetstypKommando.getResultat());
        }

        @Override
        public void handle(ErstelleSynchronisationstypKommandoMitResultat erstelleSynchronisationstypKommando) {
            Sitzung.this.prozesse.add(erstelleSynchronisationstypKommando.getResultat());
        }

        @Override
        public void handle(ErstelleVerteilungstypKommandoMitResultat erstelleVerteilungstypKommando) {
            Sitzung.this.prozesse.add(erstelleVerteilungstypKommando.getResultat());
        }

        @Override
        public void handle(FuegeQualifikationZuMitarbeiterHinzuKommando fuegeQualifikationZuMitarbeiterHinzuKommando) {
        }

        @Override
        public void handle(ErstelleMaschineKommandoMitResultat erstelleMaschineKommando) {
            Sitzung.this.maschinen.add(erstelleMaschineKommando.getResultat());
        }

        @Override
        public void handle(ErstelleMitarbeiterFaehigkeitKommando erstelleMitarbeiterFaehigkeitKommando) throws PPSException {
            Sitzung.this.mitarbeiterFaehigkeiten.add(erstelleMitarbeiterFaehigkeitKommando.getResultat());
        }

        @Override
        public void handle(ErstelleMitarbeiterKommandoMitResultat erstelleMitarbeiterKommando) {
            Sitzung.this.mitarbeiter.add(erstelleMitarbeiterKommando.getResultat());
        }

        @Override
        public void handle(ErstelleProduktionsrolleKommandoMitResultat erstelleProduktionsrolleKommando) {
            Sitzung.this.produktionsrollen.add(erstelleProduktionsrolleKommando.getResultat());
        }

        @Override
        public void handle(ErstelleQualifikationKommandoMitResultat erstelleQualifikationKommando) {
            Sitzung.this.qualifikationen.add(erstelleQualifikationKommando.getResultat());
        }

        @Override
        public void handle(FuegeFaehigkeitZuProduktionsrolleHinzuKommando fuegeFaehigkeitZuProduktionsrolleHinzuKommando) {
        }

        @Override
        public void handle(FuegeProduktionsrolleZuMitarbeiterHinzuKommando fuegeProduktionsrolleZuMitarbeiterHinzuKommando) {
        }
    }
}

