/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import util.exceptions.FractionConstructionException;
import util.fractionStyles.Decimal;
import util.fractionStyles.FractionStyle;
import util.fractionStyles.Percent;
import util.fractionStyles.Science;
import util.fractionStyles.SingleNumber;
import util.fractionStyles.SlashSeparated;

public final class Fraction
extends Number
implements Comparable<Fraction> {
    private static final String REGEX_SCIENCE_FRACTION = "-?[0-9]+E-?[0-9]+";
    private static final String REGEX_DECIMAL_FRACTION = "-?[0-9]*[.,][0-9]+";
    private static final String REGEX_SINGLENUM_FRACTION = "-?[0-9]+\\.?";
    private static final String REGEX_SLASH_SEPERATED_FRACTION = "-?[0-9]*/-?[0-9]+";
    private static final String REGEX_FRACTION_SEPERATOR = "\\.|/|,|E";
    public static final Fraction ONE = Fraction.valueOf(1);
    public static final Fraction ZERO = Fraction.valueOf(0);
    public static final long HUNDRED = 100L;
    private static final String REGEX_PERCENT_FRACTION = "\\d+%";
    private static final int SCALE = 15;
    private final BigInteger enumerator;
    private final BigInteger denominator;

    public static Fraction create(BigInteger enumerator, BigInteger denominator) throws FractionConstructionException {
        if (denominator.equals(BigInteger.ZERO)) {
            throw new FractionConstructionException("0 im Nenner!!!!!");
        }
        return new Fraction(enumerator, denominator).normalize();
    }

    private Fraction normalize() {
        BigInteger ggt = this.denominator.gcd(this.enumerator);
        if (this.denominator.signum() == -1) {
            return new Fraction(this.enumerator.divide(ggt).multiply(BigInteger.valueOf(-1L)), this.denominator.divide(ggt).multiply(BigInteger.valueOf(-1L)));
        }
        return new Fraction(this.enumerator.divide(ggt), this.denominator.divide(ggt));
    }

    public static Fraction valueOf(String fraction) throws FractionConstructionException, IllegalArgumentException {
        return Fraction.getFractionStyle(fraction).parse(fraction);
    }

    private static FractionStyle getFractionStyle(String inputString) throws IllegalArgumentException {
        if (inputString.matches(REGEX_SLASH_SEPERATED_FRACTION)) {
            return SlashSeparated.getInstance();
        }
        if (inputString.matches(REGEX_SINGLENUM_FRACTION)) {
            return SingleNumber.getInstance();
        }
        if (inputString.matches(REGEX_DECIMAL_FRACTION)) {
            return Decimal.getInstance();
        }
        if (inputString.matches(REGEX_SCIENCE_FRACTION)) {
            return Science.getInstance();
        }
        if (inputString.matches(REGEX_PERCENT_FRACTION)) {
            return Percent.getInstance();
        }
        throw new IllegalArgumentException("Die Eingabe " + inputString + " ist ung\u00fcltig!");
    }

    public static Fraction valueOf(Number value) {
        try {
            return Fraction.valueOf(value.toString());
        }
        catch (FractionConstructionException e) {
            throw new Error();
        }
    }

    private Fraction(BigInteger enumerator, BigInteger denominator) {
        this.enumerator = enumerator;
        this.denominator = denominator;
    }

    public Fraction add(Fraction summand) {
        try {
            return Fraction.create(this.enumerator.multiply(summand.denominator).add(this.denominator.multiply(summand.enumerator)), this.denominator.multiply(summand.denominator));
        }
        catch (FractionConstructionException e) {
            throw new Error(e);
        }
    }

    public Fraction multiply(Fraction factor) {
        try {
            return Fraction.create(this.enumerator.multiply(factor.enumerator), this.denominator.multiply(factor.denominator));
        }
        catch (FractionConstructionException e) {
            throw new Error(e);
        }
    }

    public Fraction subtract(Fraction subtrahend) {
        try {
            return Fraction.create(this.enumerator.multiply(subtrahend.denominator).subtract(this.denominator.multiply(subtrahend.enumerator)), this.denominator.multiply(subtrahend.denominator));
        }
        catch (FractionConstructionException e) {
            throw new Error(e);
        }
    }

    public Fraction divide(Fraction divisor) throws FractionConstructionException {
        return this.multiply(divisor.inversion());
    }

    public Fraction pow(BigInteger exponent) throws FractionConstructionException {
        if (exponent.equals(BigInteger.ZERO)) {
            return Fraction.valueOf(1);
        }
        Fraction value = exponent.signum() < 0 ? this.inversion() : this;
        Fraction divideAndConquer = value.pow(exponent.divide(BigInteger.valueOf(2L)));
        Fraction preResult = divideAndConquer.multiply(divideAndConquer);
        return exponent.mod(BigInteger.valueOf(2L)).equals(BigInteger.ZERO) ? preResult : preResult.multiply(this);
    }

    public Fraction inversion() throws FractionConstructionException {
        return Fraction.create(this.denominator, this.enumerator);
    }

    public boolean equals(Object object) {
        if (object instanceof Fraction) {
            Fraction arg = (Fraction)object;
            return this.enumerator.multiply(arg.denominator).equals(arg.enumerator.multiply(this.denominator));
        }
        return false;
    }

    public int hashCode() {
        return this.normalize().enumerator.hashCode();
    }

    public String toString() {
        return this.enumerator + "/" + this.denominator;
    }

    @Override
    public int compareTo(Fraction arg) {
        return this.enumerator.multiply(arg.denominator).compareTo(arg.enumerator.multiply(this.denominator));
    }

    public boolean lessOrEqual(Fraction arg) {
        return this.compareTo(arg) <= 0;
    }

    @Override
    public int intValue() {
        return this.enumerator.divide(this.denominator).intValue();
    }

    @Override
    public long longValue() {
        return this.enumerator.divide(this.denominator).longValue();
    }

    @Override
    public float floatValue() {
        return new BigDecimal(this.enumerator).divide(new BigDecimal(this.denominator), 15, RoundingMode.HALF_UP).floatValue();
    }

    @Override
    public double doubleValue() {
        return new BigDecimal(this.enumerator).divide(new BigDecimal(this.denominator), 15, RoundingMode.HALF_UP).doubleValue();
    }
}

