/*
 * Decompiled with CFR 0.152.
 */
package zeit.eintraege;

import auftraege.ProduktionsAuftrag;
import com.google.common.base.Objects;
import java.time.LocalDateTime;
import javax.measure.quantity.Time;
import tec.uom.se.ComparableQuantity;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.KalenderEintragTyp;

public abstract class BelegungsEintrag
extends KalenderEintrag {
    private final ProduktionsAuftrag zuVerarbeitenderAuftrag;

    protected BelegungsEintrag(LocalDateTime startZeitpunkt, ComparableQuantity<Time> dauer, ProduktionsAuftrag zuVerarbeitenderAuftrag) {
        super(startZeitpunkt, dauer, KalenderEintragTyp.BELEGT);
        this.zuVerarbeitenderAuftrag = zuVerarbeitenderAuftrag;
    }

    protected BelegungsEintrag(LocalDateTime startZeitpunkt, LocalDateTime endeZeitpunkt, ProduktionsAuftrag zuVerarbeitenderAuftrag) {
        super(startZeitpunkt, endeZeitpunkt, KalenderEintragTyp.BELEGT);
        this.zuVerarbeitenderAuftrag = zuVerarbeitenderAuftrag;
    }

    public boolean gleicherZeitraumUndProduktionsauftrag(BelegungsEintrag andererEintrag) {
        return this.getVon().equals(andererEintrag.getVon()) && this.getBis().equals(andererEintrag.getBis()) && this.getZuVerarbeitenderAuftrag().equals(andererEintrag.getZuVerarbeitenderAuftrag());
    }

    public ProduktionsAuftrag getZuVerarbeitenderAuftrag() {
        return this.zuVerarbeitenderAuftrag;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BelegungsEintrag)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BelegungsEintrag that = (BelegungsEintrag)o;
        return Objects.equal((Object)this.zuVerarbeitenderAuftrag, (Object)that.zuVerarbeitenderAuftrag);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.zuVerarbeitenderAuftrag});
    }
}

