/*
 * Decompiled with CFR 0.152.
 */
package auftraege;

import auftraege.Dokumentenklasse;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariable;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariablenVisitor;
import java.time.LocalDateTime;
import java.time.LocalTime;

public final class ServiceLevelAgreement
implements DokumentenklassenVariable {
    private static final LocalTime SPAETESTER_EINGANGSZEITPUNKT = LocalTime.of(16, 0);
    public static final ServiceLevelAgreement MAX_VALUE = new ServiceLevelAgreement(Integer.MAX_VALUE);
    private final Integer tage;

    private ServiceLevelAgreement(Integer tage) {
        this.tage = tage;
    }

    public static ServiceLevelAgreement create(Integer tage) {
        return new ServiceLevelAgreement(tage);
    }

    public LocalDateTime getFrist(LocalDateTime eingangszeiptunkt) {
        return eingangszeiptunkt.plusDays(eingangszeiptunkt.toLocalTime().isBefore(SPAETESTER_EINGANGSZEITPUNKT) ? (long)this.tage.intValue() : (long)(this.tage + 1));
    }

    public LocalDateTime getFrist(Dokumentenklasse dokumentenklasse) {
        return this.getFrist(dokumentenklasse.getEingangsZeitpunkt());
    }

    public String toString() {
        return String.valueOf(this.tage);
    }

    @Override
    public <T> T accept(DokumentenklassenVariablenVisitor<T> v) {
        return v.handle(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelAgreement that = (ServiceLevelAgreement)o;
        return this.tage.equals(that.tage);
    }

    public int hashCode() {
        return this.tage.hashCode();
    }
}

