/*
 * Decompiled with CFR 0.152.
 */
package auftraege.factory;

import auftraege.auftragsBildungsParameter.BlattAnzahlSpanne;
import auftraege.factory.DirectProduktionsauftragsParameterFactory;
import auftraege.factory.DirectVoraussichtlicheDokumentenklassenVariablenFactory;
import java.util.regex.Matcher;
import util.RegexConstants;

public enum BlattanzahlSpanneFactory implements DirectProduktionsauftragsParameterFactory<BlattAnzahlSpanne>,
DirectVoraussichtlicheDokumentenklassenVariablenFactory<BlattAnzahlSpanne>
{
    INSTANCE;


    @Override
    public BlattAnzahlSpanne parse(String wert) {
        Matcher zwischenZweiZahlenMatcher = RegexConstants.ZWISCHEN_ZWEI_ZAHLEN.matcher(wert);
        Matcher vergleichsoperatorMitZahlMatcher = RegexConstants.VERGLEICHS_OPERATOR_MIT_ZAHL.matcher(wert);
        Matcher nurZahlMatcher = RegexConstants.ZAHL.matcher(wert);
        if (vergleichsoperatorMitZahlMatcher.find()) {
            switch (vergleichsoperatorMitZahlMatcher.group(1)) {
                case "<": {
                    return new BlattAnzahlSpanne(0, Integer.parseInt(vergleichsoperatorMitZahlMatcher.group(2)));
                }
                case ">": {
                    return new BlattAnzahlSpanne(Integer.parseInt(vergleichsoperatorMitZahlMatcher.group(2)) + 1, Integer.MAX_VALUE);
                }
                case "<=": {
                    return new BlattAnzahlSpanne(0, Integer.parseInt(vergleichsoperatorMitZahlMatcher.group(2)) + 1);
                }
                case ">=": {
                    return new BlattAnzahlSpanne(Integer.parseInt(vergleichsoperatorMitZahlMatcher.group(2)), Integer.MAX_VALUE);
                }
            }
        } else {
            if (zwischenZweiZahlenMatcher.find()) {
                return new BlattAnzahlSpanne(Integer.parseInt(zwischenZweiZahlenMatcher.group(1)), Integer.parseInt(zwischenZweiZahlenMatcher.group(2)) + 1);
            }
            if (nurZahlMatcher.matches()) {
                int zahl = Integer.parseInt(nurZahlMatcher.group(1));
                return new BlattAnzahlSpanne(zahl, zahl);
            }
        }
        throw new IllegalArgumentException("Der Wert [ " + wert + " ] der Blattanzahl matcht auf keines der vorgegebenen Pattern.");
    }
}

