/*
 * Decompiled with CFR 0.152.
 */
package maschine;

import auftraege.Dokumentenklasse;
import auftraege.ProduktionsAuftrag;
import auftraege.auftragsBildungsParameter.BeilagenArten;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariable;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.Beilagenart;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.ProzessModell;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import maschine.BegrenzteBeilagenArten;
import maschine.MaschinenTyp;
import maschine.faehigkeit.DruckTyp;
import maschine.faehigkeit.Drucken;
import maschine.faehigkeit.FaehigkeitVisitor;
import maschine.faehigkeit.FarbDruckTyp;
import maschine.faehigkeit.Kuvertieren;
import maschine.faehigkeit.MaschinenFaehigkeit;
import maschine.faehigkeit.SimplesDrucken;
import maschine.faehigkeit.SimplesKuvertieren;
import material.kuvert.KuvertFormat;
import mensch.Mitarbeiter;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.Units;
import util.ClassObjectMap;
import util.Pair;
import util.exceptions.KeineVerfuegbarkeitException;
import zeit.Kalender;
import zeit.MaschinenKalender;
import zeit.TypMitKalender;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.KalenderEintragGenerell;
import zeit.eintraege.KalenderEintragVisitor;
import zeit.eintraege.MaschinenBelegungEintrag;
import zeit.eintraege.MenschBelegungEintrag;
import zeit.eintraege.Zeitraum;

public class Maschine
implements TypMitKalender {
    private final MaschinenKalender kalender = new MaschinenKalender();
    private final MaschinenTyp maschinentyp;
    private final int nummer;

    public Maschine(int nummer, MaschinenTyp maschinentyp) {
        this.nummer = nummer;
        this.maschinentyp = maschinentyp;
    }

    public MaschinenTyp getMaschinentyp() {
        return this.maschinentyp;
    }

    public int getNummer() {
        return this.nummer;
    }

    public int getAnzahlVerarbeitbarerBlaetterOderKuverts(Quantity<Time> zeitraum) {
        return this.maschinentyp.getAnzahlVerarbeitbarerBlaetterOderKuverts(zeitraum);
    }

    public boolean erfuellt(final ClassObjectMap<DokumentenklassenVariable> variablen) {
        ProzessModell prozessModell = variablen.get(ProzessModell.class).orElseThrow(() -> new NoSuchElementException("Das Prozessmodell muss enthalten sein!"));
        return prozessModell.getFaehigkeiten().stream().map(e -> e.accept(new FaehigkeitVisitor<Boolean>(){
            private final MaschinenFaehigkeit maschinenFaehigkeit;
            {
                this.maschinenFaehigkeit = Maschine.this.maschinentyp.getMaschinenFaehigkeit();
            }

            @Override
            public Boolean handle(Drucken drucken) {
                return false;
            }

            @Override
            public Boolean handle(Kuvertieren kuvertieren) {
                return false;
            }

            @Override
            public Boolean handle(SimplesDrucken simplesDrucken) {
                return this.maschinenFaehigkeit.erfuelltDruckTyp(variablen.get(DruckTyp.class).orElseThrow(() -> new NoSuchElementException("Dokumentenklassenvariablen m\u00fcssen einen Drucktypen enthalten!"))) && this.maschinenFaehigkeit.erfuelltFarbDruckTyp(variablen.get(FarbDruckTyp.class).orElseThrow(() -> new NoSuchElementException("Dokumentenklassenvariablen m\u00fcssen einen FarbDrucktypen enthalten!")));
            }

            @Override
            public Boolean handle(SimplesKuvertieren simplesKuvertieren) {
                return this.maschinenFaehigkeit.erfuelltKuvertFormat(variablen.get(KuvertFormat.class).orElseThrow(() -> new NoSuchElementException("Dokumentenklassenvariablen m\u00fcssen ein KuvertFormat enthalten!")));
            }
        })).reduce(Boolean.TRUE, (e1, e2) -> e1 != false && e2 != false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Maschine maschine = (Maschine)o;
        return this.nummer == maschine.nummer && Objects.equals(this.maschinentyp, maschine.maschinentyp);
    }

    public int hashCode() {
        return this.nummer;
    }

    @Override
    public Kalender getKalender() {
        return this.kalender;
    }

    public String toString() {
        return "Maschine{maschinentyp=" + this.maschinentyp.getName() + ", nummer=" + this.nummer + '}';
    }

    public MaschinenBelegungEintrag erstelleBelegungsEintrag(LocalDateTime start, ComparableQuantity<Time> dauer, ProduktionsAuftrag zuVerarbeitenderAuftrag) {
        MaschinenBelegungEintrag eintrag = MaschinenBelegungEintrag.create(start, dauer, zuVerarbeitenderAuftrag);
        this.getKalender().addEintrag(eintrag);
        return eintrag;
    }

    public void removeBelegungsEintrag(MaschinenBelegungEintrag eintrag) {
        this.getKalender().removeEintrag(eintrag);
    }

    public Set<MaschinenBelegungEintrag> getBelegungen() {
        return this.kalender.getBelegungen();
    }

    public Optional<Drucken> getDruckEigenschaften() {
        return this.maschinentyp.getMaschinenFaehigkeit() instanceof Drucken ? Optional.of((Drucken)this.maschinentyp.getMaschinenFaehigkeit()) : Optional.empty();
    }

    public Pair<Mitarbeiter, LocalDateTime> getAmFruehestenVerfuegbarenQualifiziertenMitarbeiter(List<Mitarbeiter> mitarbeiter, LocalDateTime abZeitpunkt, ComparableQuantity<Time> benoetigteZeit, LocalDateTime slaFrist) throws KeineVerfuegbarkeitException {
        List verfuegbarkeitenDerMaschineSortiertNachBeginn = this.getVerfuegbarkeiten(abZeitpunkt, (Quantity<Time>)benoetigteZeit, slaFrist).stream().sorted(Comparator.comparing(Zeitraum::getVon)).collect(Collectors.toList());
        Map<Mitarbeiter, Collection<Zeitraum>> verfuegbarkeitenProMitarbeiter = this.berechneVerfuegbarkeitenProQualifiziertenMitarbeiter(mitarbeiter, abZeitpunkt, benoetigteZeit, slaFrist);
        ArrayList ret = new ArrayList();
        for (Zeitraum verfuegbarkeitDerMaschine : verfuegbarkeitenDerMaschineSortiertNachBeginn) {
            for (Map.Entry<Mitarbeiter, Collection<Zeitraum>> zeitraumProMitarbeiter : verfuegbarkeitenProMitarbeiter.entrySet()) {
                Optional<LocalDateTime> potentiellerBeginnEinesZeitraums = this.findePassendenMitarbeiterZeitraumBeginn(benoetigteZeit, verfuegbarkeitDerMaschine, zeitraumProMitarbeiter);
                potentiellerBeginnEinesZeitraums.ifPresent(localDateTime -> ret.add(Pair.create(zeitraumProMitarbeiter.getKey(), localDateTime)));
            }
        }
        return ret.stream().min(Comparator.comparing(Pair::getSecond)).orElseThrow(() -> new KeineVerfuegbarkeitException(String.format("Es wurde kein Mitarbeiter gefunden, welcher in einem der foldenden Maschinenzeitslots %s verf\u00fcgbar war.", verfuegbarkeitenDerMaschineSortiertNachBeginn)));
    }

    private Map<Mitarbeiter, Collection<Zeitraum>> berechneVerfuegbarkeitenProQualifiziertenMitarbeiter(List<Mitarbeiter> mitarbeiter, LocalDateTime abZeitpunkt, ComparableQuantity<Time> benoetigteZeit, LocalDateTime slaFrist) {
        LinkedHashMap<Mitarbeiter, Collection<Zeitraum>> verfuegbarkeitenProMitarbeiter = new LinkedHashMap<Mitarbeiter, Collection<Zeitraum>>();
        this.getQualifzierteMitarbeiter(mitarbeiter).forEach(einMitarbeiter -> verfuegbarkeitenProMitarbeiter.put((Mitarbeiter)einMitarbeiter, einMitarbeiter.getVerfuegbarkeiten(abZeitpunkt, (Quantity<Time>)benoetigteZeit, slaFrist)));
        return verfuegbarkeitenProMitarbeiter;
    }

    private Optional<LocalDateTime> findePassendenMitarbeiterZeitraumBeginn(ComparableQuantity<Time> benoetigteZeit, Zeitraum verfuegbarkeitDerMaschine, Map.Entry<Mitarbeiter, Collection<Zeitraum>> zeitraeumeProMitarbeiter) {
        return zeitraeumeProMitarbeiter.getValue().stream().map(zeitraum -> zeitraum.berechneUeberschneidung(verfuegbarkeitDerMaschine)).filter(Optional::isPresent).map(zeitraum -> ((Zeitraum)zeitraum.get()).getVon()).findFirst();
    }

    private List<Mitarbeiter> getQualifzierteMitarbeiter(Collection<Mitarbeiter> mitarbeiter) {
        return mitarbeiter.stream().filter(einMitarbeiter -> einMitarbeiter.kannMaschineBedienen(this)).collect(Collectors.toList());
    }

    public MaschinenFaehigkeit getFaehigkeit() {
        return this.maschinentyp.getMaschinenFaehigkeit();
    }

    public ComparableQuantity<Time> berechneBenoetigteZeit(Dokumentenklasse dokumentenklasse) {
        return null;
    }

    public ComparableQuantity<Time> berechneBenoetigteZeit(ProduktionsAuftrag auftrag) {
        return this.maschinentyp.berechneBenoetigteZeitOhneBeilagenruestZeit(auftrag);
    }

    public ComparableQuantity<Time> berechneBenoetigteZeitInklusiveBeilagen(final ProduktionsAuftrag auftrag, final LocalDateTime arbeitsbeginn) {
        return this.maschinentyp.getMaschinenFaehigkeit().accept(new FaehigkeitVisitor<ComparableQuantity<Time>>(){

            @Override
            public ComparableQuantity<Time> handle(Drucken drucken) {
                return Maschine.this.berechneBenoetigteZeit(auftrag);
            }

            @Override
            public ComparableQuantity<Time> handle(Kuvertieren kuvertieren) {
                BegrenzteBeilagenArten begrenzteBeilagenArten = Maschine.this.getLetztenBelegungseintragVorZeitpunkt(arbeitsbeginn).map(MaschinenBelegungEintrag::getBeilagenKonfiguration).orElseGet(() -> new BegrenzteBeilagenArten(new HashSet<Beilagenart>(), kuvertieren.getAnzahlMoeglicherBeilagen()));
                int noetigeUmruestungen = begrenzteBeilagenArten.calculateUmruestvorgaengeZuNeuerBeilagenArt(auftrag.getBeilagenArten());
                ComparableQuantity toBeAdded = Maschine.this.getMaschinentyp().getBeilagenRuestzeit().multiply((Number)noetigeUmruestungen);
                return Maschine.this.berechneBenoetigteZeit(auftrag).add((Quantity)toBeAdded);
            }

            @Override
            public ComparableQuantity<Time> handle(SimplesDrucken simplesDrucken) {
                return null;
            }

            @Override
            public ComparableQuantity<Time> handle(SimplesKuvertieren simplesKuvertieren) {
                return null;
            }
        });
    }

    public Optional<Integer> getAnzahlMoeglicherBeilagen() {
        return this.getMaschinentyp().getMaschinenFaehigkeit().accept(new FaehigkeitVisitor<Optional<Integer>>(){

            @Override
            public Optional<Integer> handle(Drucken drucken) {
                return Optional.empty();
            }

            @Override
            public Optional<Integer> handle(Kuvertieren kuvertieren) {
                return Optional.of(kuvertieren.getAnzahlMoeglicherBeilagen());
            }

            @Override
            public Optional<Integer> handle(SimplesDrucken simplesDrucken) {
                return Optional.empty();
            }

            @Override
            public Optional<Integer> handle(SimplesKuvertieren simplesKuvertieren) {
                return Optional.empty();
            }
        });
    }

    public Optional<MaschinenBelegungEintrag> getLetztenBelegungseintragVorZeitpunkt(LocalDateTime zeitpunkt) {
        Optional<KalenderEintrag> letztenEintragVorZeitpunkt = this.kalender.getLetztenEintragVorZeitpunkt(zeitpunkt);
        return letztenEintragVorZeitpunkt.flatMap(eintrag -> eintrag.accept(new KalenderEintragVisitor<Optional<MaschinenBelegungEintrag>>(){

            @Override
            public Optional<MaschinenBelegungEintrag> handle(MaschinenBelegungEintrag maschinenBelegungEintrag) {
                return Optional.of(maschinenBelegungEintrag);
            }

            @Override
            public Optional<MaschinenBelegungEintrag> handle(MenschBelegungEintrag menschBelegungEintrag) {
                return Optional.empty();
            }

            @Override
            public Optional<MaschinenBelegungEintrag> handle(KalenderEintragGenerell kalenderEintragGenerell) {
                return Optional.empty();
            }
        }));
    }

    public ComparableQuantity<Time> calculateUmruestungen(ProduktionsAuftrag auftrag, LocalDateTime value) {
        BegrenzteBeilagenArten begrenzteBeilagenArten = this.getLetztenBelegungseintragVorZeitpunkt(value).map(MaschinenBelegungEintrag::getBeilagenKonfiguration).orElseGet(() -> new BegrenzteBeilagenArten(new HashSet<Beilagenart>(), this.getFaehigkeit().accept(new FaehigkeitVisitor<Integer>(){

            @Override
            public Integer handle(Drucken drucken) {
                return 0;
            }

            @Override
            public Integer handle(Kuvertieren kuvertieren) {
                return kuvertieren.getAnzahlMoeglicherBeilagen();
            }

            @Override
            public Integer handle(SimplesDrucken simplesDrucken) {
                return null;
            }

            @Override
            public Integer handle(SimplesKuvertieren simplesKuvertieren) {
                return null;
            }
        })));
        if (begrenzteBeilagenArten.getBegrenzung() == 0) {
            return Quantities.getQuantity((Number)0, (Unit)Units.SECOND);
        }
        BeilagenArten beilagenArten = auftrag.getBeilagenArten();
        int umruestungen = begrenzteBeilagenArten.calculateUmruestvorgaengeZuNeuerBeilagenArt(beilagenArten);
        return this.getMaschinentyp().getBeilagenRuestzeit().multiply((Number)umruestungen);
    }
}

