/*
 * Decompiled with CFR 0.152.
 */
package auftraege.factory;

import auftraege.factory.DirectProduktionsauftragsParameterFactory;
import java.time.LocalDate;
import java.util.regex.Matcher;
import util.Constants;
import util.RegexConstants;
import zeit.eintraege.Zeitraum;

public enum ZeitraumFactory implements DirectProduktionsauftragsParameterFactory<Zeitraum>
{
    INSTANCE;


    @Override
    public Zeitraum parse(String wert) {
        Matcher zwischenZweiDatenMatcher = RegexConstants.ZWISCHEN_ZWEI_DATEN.matcher(wert);
        Matcher vergleichsoperatorDatumMatcher = RegexConstants.VERGLEICHS_OPERATOR_MIT_DATUM.matcher(wert);
        if (zwischenZweiDatenMatcher.find()) {
            return Zeitraum.create(LocalDate.parse(zwischenZweiDatenMatcher.group(1), Constants.FORMATTER_GER_DATE), LocalDate.parse(zwischenZweiDatenMatcher.group(2), Constants.FORMATTER_GER_DATE));
        }
        if (vergleichsoperatorDatumMatcher.find()) {
            String datum = vergleichsoperatorDatumMatcher.group(2);
            switch (vergleichsoperatorDatumMatcher.group(1)) {
                case "<": {
                    return Zeitraum.create(LocalDate.MIN, LocalDate.parse(datum, Constants.FORMATTER_GER_DATE));
                }
                case ">": {
                    return Zeitraum.create(LocalDate.parse(datum, Constants.FORMATTER_GER_DATE).plusDays(1L), LocalDate.MAX);
                }
                case "<=": {
                    return Zeitraum.create(LocalDate.MIN, LocalDate.parse(datum, Constants.FORMATTER_GER_DATE).plusDays(1L));
                }
                case ">=": {
                    return Zeitraum.create(LocalDate.parse(datum, Constants.FORMATTER_GER_DATE), LocalDate.MAX);
                }
            }
        }
        throw new IllegalArgumentException("Der Wert [ " + wert + " ] des SLA matcht auf keines der vorgegebenen Pattern.");
    }
}

