/*
 * Decompiled with CFR 0.152.
 */
package rollenbelegung;

import auftraege.ProduktionsAuftrag;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.measure.Quantity;
import maschine.BegrenzteBeilagenArten;
import maschine.Maschine;
import maschine.faehigkeit.Drucken;
import maschine.faehigkeit.FaehigkeitVisitor;
import maschine.faehigkeit.Kuvertieren;
import maschine.faehigkeit.MaschinenFaehigkeit;
import maschine.faehigkeit.SimplesDrucken;
import maschine.faehigkeit.SimplesKuvertieren;
import mensch.Mitarbeiter;
import rollenbelegung.ErmittelteBelegungen;
import rollenbelegung.MaschinenBelegung;
import rollenbelegung.MaschinenRollenbelegungService;
import rollenbelegung.MitarbeiterBelegung;
import rollenbelegung.SortierHelper;
import rollenbelegung.SortierParameter.MaschinenRollenbelegungServiceParameter;
import rollenbelegung.SortierParameter.ZuordnungsParameter;
import tec.uom.se.ComparableQuantity;
import util.ClassObjectMap;
import util.Pair;
import util.exceptions.KeineVerfuegbarkeitException;
import zeit.TypMitKalender;
import zeit.eintraege.BelegungsEintrag;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.MaschinenBelegungEintrag;
import zeit.eintraege.MenschBelegungEintrag;

public class Produktionsplaner
implements MaschinenRollenbelegungService {
    @Override
    public ErmittelteBelegungen findeBelegung(List<Maschine> maschinen, List<Mitarbeiter> mitarbeiter, List<ProduktionsAuftrag> produktionsAuftraege, MaschinenRollenbelegungServiceParameter parameter) {
        return new InternalProduktionsplaner(maschinen, mitarbeiter, parameter).plan(produktionsAuftraege);
    }

    @Override
    public ErmittelteBelegungen findeBelegungAberErzeugeKeineKalendereintraege(List<Maschine> maschinen, List<Mitarbeiter> mitarbeiter, List<ProduktionsAuftrag> produktionsAuftraege, MaschinenRollenbelegungServiceParameter parameter) {
        return new InternalProduktionsplaner(maschinen, mitarbeiter, parameter).planAberErzeugeKeineKalendereintraege(produktionsAuftraege);
    }

    public Map<MaschinenFaehigkeit, Collection<Maschine>> getQualifizierteMaschinenProBenoetigteFaehigkeit(Collection<Maschine> evtlQualifizierteMaschinen, ProduktionsAuftrag auftrag) {
        return InternalProduktionsplaner.getQualifizierteMaschinenProBenoetigteFaehigkeit(evtlQualifizierteMaschinen, auftrag);
    }

    static class InternalProduktionsplaner {
        private final SortierHelper sortierHelper = SortierHelper.create();
        private final List<Maschine> maschinen;
        private final List<Mitarbeiter> mitarbeiter;
        private final MaschinenRollenbelegungServiceParameter parameter;

        InternalProduktionsplaner(List<Maschine> maschinen, List<Mitarbeiter> mitarbeiter, MaschinenRollenbelegungServiceParameter parameter) {
            this.maschinen = new ArrayList<Maschine>(maschinen);
            this.mitarbeiter = new ArrayList<Mitarbeiter>(mitarbeiter);
            this.parameter = parameter;
        }

        private ErmittelteBelegungen plan(List<ProduktionsAuftrag> produktionsAuftraege) {
            this.sortierHelper.sortiereProduktionsAuftraegeUndMaschinenUndMitarbeiter(produktionsAuftraege, this.maschinen, this.mitarbeiter, this.parameter);
            ArrayList<ProduktionsAuftrag> nichtZugeordneteAuftraege = new ArrayList<ProduktionsAuftrag>();
            for (ProduktionsAuftrag auftrag : produktionsAuftraege) {
                if (this.zuordnen(auftrag)) continue;
                nichtZugeordneteAuftraege.add(auftrag);
            }
            return new ErmittelteBelegungen(nichtZugeordneteAuftraege, this.getMaschinenBelegungen(this.maschinen), this.getMitarbeiterBelegungen(this.mitarbeiter));
        }

        private boolean zuordnen(ProduktionsAuftrag auftrag) {
            Map<MaschinenFaehigkeit, Collection<Maschine>> qualifizierteMaschinen = InternalProduktionsplaner.getQualifizierteMaschinenProBenoetigteFaehigkeit(this.maschinen, auftrag);
            boolean wurdeAllesZugeordnet = qualifizierteMaschinen.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(qualifizierteMaschinenNachFaehigkeit -> {
                try {
                    Map.Entry<Pair<Maschine, Mitarbeiter>, LocalDateTime> mitarbeiterMaschineUndFruehesteVerfuegbarkeit = this.findeMaschineUndMitarbeiterNachZuordnungsParameter((Map.Entry<MaschinenFaehigkeit, Collection<Maschine>>)qualifizierteMaschinenNachFaehigkeit, auftrag);
                    this.erzeugeAuftragsBelegungsEintraege(mitarbeiterMaschineUndFruehesteVerfuegbarkeit, auftrag);
                    return true;
                }
                catch (KeineVerfuegbarkeitException e) {
                    return false;
                }
            }).reduce(Boolean.TRUE, Boolean::logicalAnd);
            if (wurdeAllesZugeordnet) {
                auftrag.getMaschinenBelegungen().forEach(TypMitKalender::addBelegungsEintrag);
                auftrag.getMenschBelegungen().forEach((key, value) -> ((Mitarbeiter)key.getFirst()).addBelegungsEintrag((BelegungsEintrag)value));
            } else {
                auftrag.clearBelegungsEintraege();
            }
            return wurdeAllesZugeordnet;
        }

        private void erzeugeAuftragsBelegungsEintraege(Map.Entry<Pair<Maschine, Mitarbeiter>, LocalDateTime> mitarbeiterMaschineUndFruehesteVerfuegbarkeit, ProduktionsAuftrag auftrag) {
            Maschine maschineFuerAuftrag = (Maschine)mitarbeiterMaschineUndFruehesteVerfuegbarkeit.getKey().getFirst();
            Mitarbeiter mitarbeiterFuerAuftrag = (Mitarbeiter)mitarbeiterMaschineUndFruehesteVerfuegbarkeit.getKey().getSecond();
            LocalDateTime arbeitsbeginn = mitarbeiterMaschineUndFruehesteVerfuegbarkeit.getValue();
            ComparableQuantity benoetigteZeit = maschineFuerAuftrag.berechneBenoetigteZeitInklusiveBeilagen(auftrag, arbeitsbeginn);
            BegrenzteBeilagenArten zeitbezogeneBeilagenArtenKonfiguration = maschineFuerAuftrag.getLetztenBelegungseintragVorZeitpunkt(arbeitsbeginn).map(MaschinenBelegungEintrag::getBeilagenKonfiguration).map(BegrenzteBeilagenArten::copy).orElseGet(() -> (BegrenzteBeilagenArten)maschineFuerAuftrag.getFaehigkeit().accept((FaehigkeitVisitor)new FaehigkeitVisitor<BegrenzteBeilagenArten>(){

                public BegrenzteBeilagenArten handle(Drucken drucken) {
                    return BegrenzteBeilagenArten.EMPTY;
                }

                public BegrenzteBeilagenArten handle(Kuvertieren kuvertieren) {
                    return new BegrenzteBeilagenArten(new HashSet(), kuvertieren.getAnzahlMoeglicherBeilagen());
                }

                public BegrenzteBeilagenArten handle(SimplesDrucken simplesDrucken) {
                    return null;
                }

                public BegrenzteBeilagenArten handle(SimplesKuvertieren simplesKuvertieren) {
                    return null;
                }
            }));
            if (!zeitbezogeneBeilagenArtenKonfiguration.isNotEditable()) {
                zeitbezogeneBeilagenArtenKonfiguration.manageNecessaryChangesToFitBeilagenArten(auftrag);
            }
            MaschinenBelegungEintrag maschinenBelegungEintrag = MaschinenBelegungEintrag.create((LocalDateTime)arbeitsbeginn, (ComparableQuantity)benoetigteZeit, (ProduktionsAuftrag)auftrag, (BegrenzteBeilagenArten)zeitbezogeneBeilagenArtenKonfiguration);
            auftrag.addMaschinenBelegungsEintrag(maschineFuerAuftrag, maschinenBelegungEintrag);
            MenschBelegungEintrag menschBelegungEintrag = MenschBelegungEintrag.create((LocalDateTime)arbeitsbeginn, (ComparableQuantity)benoetigteZeit, (ProduktionsAuftrag)auftrag, (Maschine)maschineFuerAuftrag);
            auftrag.addMenschBelegungsEintrag(mitarbeiterFuerAuftrag, maschineFuerAuftrag.getFaehigkeit(), menschBelegungEintrag);
        }

        private Map.Entry<Pair<Maschine, Mitarbeiter>, LocalDateTime> findeMaschineUndMitarbeiterNachZuordnungsParameter(Map.Entry<MaschinenFaehigkeit, Collection<Maschine>> qualifizierteMaschinenNachFaehigkeit, ProduktionsAuftrag auftrag) throws KeineVerfuegbarkeitException {
            LinkedHashMap<Object, Object> mitarbeiterFuerMaschineMitFruehesterVerfuegbarkeitMap = new LinkedHashMap<Object, Object>();
            for (Maschine currentMaschine : qualifizierteMaschinenNachFaehigkeit.getValue()) {
                try {
                    Pair<Pair<Maschine, Mitarbeiter>, LocalDateTime> mitarbeiterMaschineUndVerfuegbarkeit = this.findeMaschineUndMitarbeiter(currentMaschine, auftrag);
                    mitarbeiterFuerMaschineMitFruehesterVerfuegbarkeitMap.put(mitarbeiterMaschineUndVerfuegbarkeit.getFirst(), mitarbeiterMaschineUndVerfuegbarkeit.getSecond());
                }
                catch (KeineVerfuegbarkeitException keineVerfuegbarkeitException) {}
            }
            ZuordnungsParameter zuordnungsParameter = this.parameter.getZuordnungsParameter();
            switch (zuordnungsParameter) {
                case FRUEHEST_VERFUEGBARE_MASCHINE: {
                    return mitarbeiterFuerMaschineMitFruehesterVerfuegbarkeitMap.entrySet().stream().min(Comparator.comparing(Map.Entry::getValue)).orElseThrow(() -> new KeineVerfuegbarkeitException(""));
                }
                case GERINGSTE_UMRUESTUNGEN: {
                    return mitarbeiterFuerMaschineMitFruehesterVerfuegbarkeitMap.entrySet().stream().min(Comparator.comparing(pairLocalDateTimeEntry -> ((Maschine)((Pair)pairLocalDateTimeEntry.getKey()).getFirst()).calculateUmruestungen(auftrag, (LocalDateTime)pairLocalDateTimeEntry.getValue())).thenComparing(Map.Entry::getValue)).orElseThrow(() -> new KeineVerfuegbarkeitException(""));
                }
            }
            throw new RuntimeException("Es muss ein zuordnungsParameter gesetzt sein!");
        }

        private Pair<Pair<Maschine, Mitarbeiter>, LocalDateTime> findeMaschineUndMitarbeiter(Maschine maschine, ProduktionsAuftrag auftrag) throws KeineVerfuegbarkeitException {
            ComparableQuantity benoetigteZeit = maschine.berechneBenoetigteZeit(auftrag);
            LocalDateTime start = maschine.getFruehesteVerfuegbarkeit(this.getFruehesteStartZeit(auftrag), (Quantity)benoetigteZeit, auftrag.getSla().getFrist(auftrag.getFruehstenEingangszeitpunkt()));
            Pair mitarbeiterMitZeitpunkt = maschine.getAmFruehestenVerfuegbarenQualifiziertenMitarbeiter(this.mitarbeiter, start, benoetigteZeit, auftrag.getSla().getFrist(auftrag.getFruehstenEingangszeitpunkt()));
            return Pair.create((Object)Pair.create((Object)maschine, (Object)mitarbeiterMitZeitpunkt.getFirst()), (Object)mitarbeiterMitZeitpunkt.getSecond());
        }

        private LocalDateTime getFruehesteStartZeit(ProduktionsAuftrag auftrag) {
            return auftrag.getMaschinenBelegungen().values().stream().map(KalenderEintrag::getBis).max(Comparator.comparing(e -> e)).orElseGet(this.parameter::getStartZeit);
        }

        private static Map<MaschinenFaehigkeit, Collection<Maschine>> getQualifizierteMaschinenProBenoetigteFaehigkeit(Collection<Maschine> evtlQualifizierteMaschinen, ProduktionsAuftrag auftrag) {
            Map maschinenRelevanteFaehigkeiten = auftrag.getMaschinenRelevanteFaehigkeiten();
            return maschinenRelevanteFaehigkeiten.entrySet().stream().map(entry -> {
                ClassObjectMap zuErfuellendeEigenschaften = (ClassObjectMap)entry.getValue();
                return Pair.create(entry.getKey(), evtlQualifizierteMaschinen.stream().filter(maschine -> maschine.erfuellt(zuErfuellendeEigenschaften)).collect(Collectors.toList()));
            }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        }

        private Map<Mitarbeiter, MitarbeiterBelegung> getMitarbeiterBelegungen(List<Mitarbeiter> mitarbeiterListe) {
            return mitarbeiterListe.stream().collect(Collectors.toMap(e -> e, e -> new MitarbeiterBelegung(e.getBelegungen())));
        }

        private Map<Maschine, MaschinenBelegung> getMaschinenBelegungen(List<Maschine> maschinenListe) {
            return maschinenListe.stream().collect(Collectors.toMap(e -> e, e -> new MaschinenBelegung(e.getBelegungen())));
        }

        public ErmittelteBelegungen planAberErzeugeKeineKalendereintraege(List<ProduktionsAuftrag> produktionsAuftraege) {
            ErmittelteBelegungen ermittelteBelegungen = this.plan(produktionsAuftraege);
            this.loescheUngueltigeBelegungen(produktionsAuftraege);
            return ermittelteBelegungen;
        }

        private void loescheUngueltigeBelegungen(List<ProduktionsAuftrag> produktionsAuftraege) {
            produktionsAuftraege.forEach(p -> {
                p.getMaschinenBelegungen().forEach(Maschine::removeBelegungsEintrag);
                p.getMenschBelegungen().forEach((key, value) -> ((Mitarbeiter)key.getFirst()).removeBelegungsEintrag(value));
                p.clearBelegungsEintraege();
            });
        }
    }
}

