/*
 * Decompiled with CFR 0.152.
 */
package auftraege;

import auftraege.ServiceLevelAgreement;
import auftraege.Variable;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariable;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.BlattAnzahl;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.Id;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.ProzessModell;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.SendungsAnzahl;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.UnbekannteVariable;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.UnbekannteVariablen;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import util.ClassObjectMap;
import util.Numberable;

public class Dokumentenklasse {
    private final ClassObjectMap<DokumentenklassenVariable> variablen;
    private final LocalDateTime eingangsZeitpunkt;

    public Dokumentenklasse(List<Variable> variablen, LocalDateTime eingangsZeitpunkt) {
        this.variablen = new ClassObjectMap();
        Map<Boolean, List<DokumentenklassenVariable>> variablenMapInBeUndUnbekanntGeteilt = variablen.stream().filter(variable -> !variable.getWert().equals("")).map(variable -> DokumentenklassenVariable.create(variable.getBezeichung(), variable.getWert())).collect(Collectors.partitioningBy(UnbekannteVariable.class::isInstance));
        List<DokumentenklassenVariable> unbekannte = variablenMapInBeUndUnbekanntGeteilt.get(Boolean.TRUE);
        if (!unbekannte.isEmpty()) {
            this.variablen.put(new UnbekannteVariablen(unbekannte.stream().map(UnbekannteVariable.class::cast).collect(Collectors.toList())));
        }
        variablenMapInBeUndUnbekanntGeteilt.get(Boolean.FALSE).forEach(this.variablen::put);
        this.eingangsZeitpunkt = eingangsZeitpunkt;
    }

    public Dokumentenklasse(ClassObjectMap<DokumentenklassenVariable> variablen, LocalDateTime eingangsZeitpunkt) {
        this.variablen = variablen;
        this.eingangsZeitpunkt = eingangsZeitpunkt;
    }

    public static Dokumentenklasse create(LocalDateTime eingangsZeitpunkt, DokumentenklassenVariable ... variablen) {
        ClassObjectMap<DokumentenklassenVariable> classObjectMap = new ClassObjectMap<DokumentenklassenVariable>();
        Arrays.stream(variablen).forEach(classObjectMap::put);
        return new Dokumentenklasse(classObjectMap, eingangsZeitpunkt);
    }

    public int getAnzahlBlaetter() {
        Optional<BlattAnzahl> blattAnzahl = this.variablen.get(BlattAnzahl.class);
        return blattAnzahl.map(Numberable::intValue).orElse(0);
    }

    public int getAnzahlSendungen() {
        return this.variablen.get(SendungsAnzahl.class).map(SendungsAnzahl::getSendungsAnzahl).orElse(0);
    }

    public ServiceLevelAgreement getSla() {
        return this.variablen.get(ServiceLevelAgreement.class).orElse(ServiceLevelAgreement.MAX_VALUE);
    }

    public ProzessModell getProzessModell() {
        return this.variablen.get(ProzessModell.class).orElseThrow(NoSuchElementException::new);
    }

    public Optional<Integer> getId() {
        return this.variablen.get(Id.class).map(Id::getId);
    }

    public ClassObjectMap<DokumentenklassenVariable> getVariablen() {
        return this.variablen;
    }

    <T extends DokumentenklassenVariable> Optional<T> getVariable(Class<T> clazz) {
        return this.variablen.get(clazz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dokumentenklasse)) {
            return false;
        }
        Dokumentenklasse that = (Dokumentenklasse)o;
        if (!this.variablen.equals(that.variablen)) {
            return false;
        }
        return this.eingangsZeitpunkt.equals(that.eingangsZeitpunkt);
    }

    public int hashCode() {
        int result = this.variablen.hashCode();
        result = 31 * result + this.eingangsZeitpunkt.hashCode();
        return result;
    }

    public String toString() {
        return "Dokumentenklasse{" + this.eingangsZeitpunkt + " " + this.variablen.get(Id.class).map(Object::toString).orElse(this.variablen.toString()) + '}';
    }

    public LocalDateTime getEingangsZeitpunkt() {
        return this.eingangsZeitpunkt;
    }

    public LocalDateTime getFrist() {
        return this.getSla().getFrist(this);
    }
}

