/*
 * Decompiled with CFR 0.152.
 */
package auftraege.factory;

import auftraege.factory.DirectVoraussichtlicheDokumentenklassenVariablenFactory;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.Units;
import util.RegexConstants;
import util.exceptions.SollteNichtPassierenException;
import zeit.eintraege.KalenderEintragGenerell;
import zeit.eintraege.KalenderEintragTyp;
import zeit.serientermin.SerienTermin;

public enum SerienTerminFactory implements DirectVoraussichtlicheDokumentenklassenVariablenFactory<SerienTermin>
{
    INSTANCE;

    private static final int TURNUS_GRUPPE = 3;
    private static final int PLUSTAGE_GRUPPE = 2;
    private static final int DATUM_GRUPPE = 1;
    private static final ComparableQuantity<Time> MONATS_GESCHUMMEL;

    @Override
    public SerienTermin parse(String wert) {
        Pattern pattern = Pattern.compile(RegexConstants.DATUM.pattern() + "\\s*\\+?\\s*" + RegexConstants.ZAHL + "?\\s*(j\u00e4hrlich|monatlich|w\u00f6chentlich)?");
        Matcher matcher = pattern.matcher(wert);
        if (matcher.find()) {
            LocalDateTime datum = LocalDate.parse(matcher.group(1), DateTimeFormatter.ofPattern("dd.MM.yyyy")).atStartOfDay();
            ComparableQuantity plusTage = Quantities.getQuantity((Number)(Optional.ofNullable(matcher.group(2)).map(Integer::valueOf).orElse(0) + 1), (Unit)Units.DAY);
            KalenderEintragGenerell eintrag = KalenderEintragGenerell.create(datum, (ComparableQuantity<Time>)plusTage, KalenderEintragTyp.VERFUEGBAR);
            return Optional.ofNullable(matcher.group(3)).map(s -> {
                switch (s) {
                    case "j\u00e4hrlich": {
                        return SerienTermin.createSerienterminMitIntervall(eintrag, (ComparableQuantity<Time>)Quantities.getQuantity((Number)1, (Unit)Units.YEAR));
                    }
                    case "monatlich": {
                        return SerienTermin.createMonatlichenSerientermin(eintrag);
                    }
                    case "w\u00f6chentlich": {
                        return SerienTermin.createSerienterminMitIntervall(eintrag, (ComparableQuantity<Time>)Quantities.getQuantity((Number)1, (Unit)Units.WEEK));
                    }
                }
                throw new SollteNichtPassierenException("das hier passiert nicht!");
            }).orElse(SerienTermin.createSerienterminMitIntervall(eintrag, (ComparableQuantity<Time>)Quantities.getQuantity((Number)Integer.MAX_VALUE, (Unit)Units.YEAR)));
        }
        throw new IllegalArgumentException(String.format("der Wert [%s] konnte nicht geparsed werden!", wert));
    }

    static {
        MONATS_GESCHUMMEL = Quantities.getQuantity((Number)-1, (Unit)Units.DAY);
    }
}

