/*
 * Decompiled with CFR 0.152.
 */
package maschine;

import auftraege.Dokumentenklasse;
import auftraege.ProduktionsAuftrag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import maschine.MaschinentypPersonalbindung;
import maschine.faehigkeit.Drucken;
import maschine.faehigkeit.FaehigkeitVisitor;
import maschine.faehigkeit.Kuvertieren;
import maschine.faehigkeit.MaschinenFaehigkeit;
import maschine.faehigkeit.SimplesDrucken;
import maschine.faehigkeit.SimplesKuvertieren;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.Units;
import util.Fraction;

public class MaschinenTyp {
    private final String name;
    private final MaschinenFaehigkeit maschinenFaehigkeit;
    private final Collection<MaschinentypPersonalbindung> personalbindungen;
    private final int verarbeitbareBlaetterOderKuvertsProStunde;
    private final ComparableQuantity<Time> ruestzeit;
    private final ComparableQuantity<Time> beilagenRuestzeit;

    public MaschinenTyp(String name, MaschinenFaehigkeit maschinenFaehigkeit, int verarbeitbareBlaetterOderKuvertsProStunde, ComparableQuantity<Time> ruestzeit, ComparableQuantity<Time> beilagenRuestzeit) {
        this.name = name;
        this.maschinenFaehigkeit = maschinenFaehigkeit;
        this.verarbeitbareBlaetterOderKuvertsProStunde = verarbeitbareBlaetterOderKuvertsProStunde;
        this.ruestzeit = ruestzeit;
        this.beilagenRuestzeit = beilagenRuestzeit;
        this.personalbindungen = new ArrayList<MaschinentypPersonalbindung>();
    }

    public String getName() {
        return this.name;
    }

    public MaschinenFaehigkeit getMaschinenFaehigkeit() {
        return this.maschinenFaehigkeit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaschinenTyp that = (MaschinenTyp)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.maschinenFaehigkeit, that.maschinenFaehigkeit) && Objects.equals(this.personalbindungen, that.personalbindungen);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.maschinenFaehigkeit, this.personalbindungen);
    }

    int getAnzahlVerarbeitbarerBlaetterOderKuverts(Quantity<Time> zeitraum) {
        return zeitraum.to(Units.HOUR).getValue().intValue() * this.verarbeitbareBlaetterOderKuvertsProStunde;
    }

    public ComparableQuantity<Time> berechneBenoetigteZeitOhneBeilagenruestZeit(ProduktionsAuftrag auftrag) {
        return auftrag.getDokumentenklassen().stream().map(this::berechneBenoetigteZeitOhneBeilagenruestZeit).reduce(ComparableQuantity::add).orElse(Quantities.getQuantity((Number)0, (Unit)Units.HOUR));
    }

    private ComparableQuantity<Time> berechneBenoetigteZeitOhneBeilagenruestZeit(final Dokumentenklasse dokumentenklasse) {
        Fraction anzahl = this.maschinenFaehigkeit.accept(new FaehigkeitVisitor<Fraction>(){

            @Override
            public Fraction handle(Drucken drucken) {
                return Fraction.valueOf(dokumentenklasse.getAnzahlBlaetter());
            }

            @Override
            public Fraction handle(Kuvertieren kuvertieren) {
                return Fraction.valueOf(dokumentenklasse.getAnzahlSendungen());
            }

            @Override
            public Fraction handle(SimplesDrucken simplesDrucken) {
                return null;
            }

            @Override
            public Fraction handle(SimplesKuvertieren simplesKuvertieren) {
                return null;
            }
        });
        Fraction verarbeitbareBlaetterProStunde = Fraction.valueOf(this.getAnzahlVerarbeitbarerBlaetterOderKuverts((Quantity<Time>)Quantities.getQuantity((Number)1, (Unit)Units.HOUR)));
        ComparableQuantity verarbeitungsDauer = Quantities.getQuantity((Number)anzahl.divide(verarbeitbareBlaetterProStunde), (Unit)Units.HOUR);
        return verarbeitungsDauer.add(this.getRuestzeit());
    }

    public ComparableQuantity<Time> getRuestzeit() {
        return this.ruestzeit;
    }

    public ComparableQuantity<Time> getBeilagenRuestzeit() {
        return this.beilagenRuestzeit;
    }

    public String toString() {
        return "MaschinenTyp{name='" + this.name + '\'' + '}';
    }
}

