/*
 * Decompiled with CFR 0.152.
 */
package zeit.serientermin;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Collections;
import zeit.ZeitUtils;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.Zeitraum;
import zeit.serientermin.CreatePassendenKalenderEintragMitZeitraumVisitor;
import zeit.serientermin.MonatlicherSerienterminNachDem28Exception;
import zeit.serientermin.SerienTermin;

public final class MonatlicherSerientermin
extends SerienTermin {
    public static final int MINIMALE_ANZAHL_TAGE_PRO_MONAT = 28;

    private MonatlicherSerientermin(KalenderEintrag eintrag) {
        super(eintrag);
    }

    public static MonatlicherSerientermin create(KalenderEintrag eintrag) {
        if (eintrag.getVon().getDayOfMonth() > 28) {
            throw new MonatlicherSerienterminNachDem28Exception(String.format("Ein monatlicher Serientermin am %s liegt nach dem 28 und ist nicht erlaubt", eintrag.getVon().getDayOfMonth()));
        }
        return new MonatlicherSerientermin(eintrag);
    }

    @Override
    protected Collection<KalenderEintrag> berechneKalenderEintraegeZumTag(LocalDate tag) {
        LocalDate laufendesDatum = this.getEintrag().getVon().toLocalDate();
        while (laufendesDatum.isBefore(tag) || laufendesDatum.equals(tag)) {
            Zeitraum zeitraum = Zeitraum.create(LocalDateTime.of(laufendesDatum, LocalTime.of(this.getEintrag().getVon().getHour(), this.getEintrag().getVon().getMinute())), this.getEintrag().getDauer());
            if (this.zeitraumAmTag(zeitraum, tag)) {
                return Collections.singleton(this.getEintrag().accept(new CreatePassendenKalenderEintragMitZeitraumVisitor(zeitraum)));
            }
            laufendesDatum = ZeitUtils.verschiebeDatumUmEinenMonat(laufendesDatum);
        }
        return Collections.emptySet();
    }
}

