/*
 * Decompiled with CFR 0.152.
 */
package zeit;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.quantity.time.TimeQuantities;
import tec.uom.se.unit.Units;

public final class ZeitUtils {
    private ZeitUtils() {
    }

    public static LocalDateTime addTime(LocalDateTime date, Quantity<Time> time) {
        return date.plus(TimeQuantities.toTemporalSeconds(time).getTemporalAmount());
    }

    public static ComparableQuantity<Time> calcTimeBetween(LocalDateTime von, LocalDateTime bis) {
        return Quantities.getQuantity((Number)ChronoUnit.SECONDS.between(von, bis), (Unit)Units.SECOND);
    }

    public static LocalDateTime verschiebeZeitpunktUmEinenMonat(LocalDateTime zeitpunkt) {
        return LocalDateTime.of(ZeitUtils.verschiebeDatumUmEinenMonat(zeitpunkt.toLocalDate()), LocalTime.of(zeitpunkt.getHour(), zeitpunkt.getMinute()));
    }

    public static LocalDate verschiebeDatumUmEinenMonat(LocalDate datum) {
        Month newMonth = datum.getMonth().plus(1L);
        int newOrOldYear = datum.getYear();
        if (newMonth.equals(Month.JANUARY)) {
            ++newOrOldYear;
        }
        return LocalDate.of(newOrOldYear, newMonth, datum.getDayOfMonth());
    }
}

