/*
 * Decompiled with CFR 0.152.
 */
package simulation.SimulationsHelper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import maschine.Maschine;
import mensch.Mitarbeiter;
import rollenbelegung.Belegung;
import rollenbelegung.ErmittelteBelegungen;
import zeit.TypMitKalender;
import zeit.eintraege.BelegungsEintrag;

public final class UeberbuchungsHelper {
    private UeberbuchungsHelper() {
    }

    public static UeberbuchungsHelper create() {
        return new UeberbuchungsHelper();
    }

    public Collection<Mitarbeiter> ermittleUeberbuchteMitarbeiter(ErmittelteBelegungen ermittelteBelegungen) {
        return this.ermittleUberbuchteTypenMitKalender(ermittelteBelegungen.getMitarbeiterbelegungen());
    }

    public Collection<Maschine> ermittleUeberbuchteMaschinen(ErmittelteBelegungen ermittelteBelegungen) {
        return this.ermittleUberbuchteTypenMitKalender(ermittelteBelegungen.getMaschinenbelegungen());
    }

    private <T extends TypMitKalender, K extends Belegung<?>> Collection<T> ermittleUberbuchteTypenMitKalender(Map<T, K> belegungen) {
        HashSet<TypMitKalender> uerbuchteM = new HashSet<TypMitKalender>();
        for (Map.Entry<T, K> typUndBelegung : belegungen.entrySet()) {
            if (!this.istUeberbucht((TypMitKalender)typUndBelegung.getKey(), ((Belegung)typUndBelegung.getValue()).getBelegung())) continue;
            TypMitKalender key = (TypMitKalender)typUndBelegung.getKey();
            uerbuchteM.add(key);
        }
        return uerbuchteM;
    }

    private <T extends TypMitKalender, K extends BelegungsEintrag> boolean istUeberbucht(T typ, Collection<K> belegung) {
        boolean istFuerAlleBelegungenVerfuegbar = belegung.stream().allMatch(b -> typ.istVerfuegbar(b.getVon(), b.getBis()));
        return !istFuerAlleBelegungenVerfuegbar || !this.hatKeineUeberschneidendeBelegungen(belegung);
    }

    private boolean hatKeineUeberschneidendeBelegungen(Collection<? extends BelegungsEintrag> belegungen) {
        for (BelegungsEintrag belegungsEintrag : belegungen) {
            for (BelegungsEintrag belegungsEintrag2 : belegungen) {
                if (!this.liegtUeberschneigungVor(belegungsEintrag, belegungsEintrag2)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean liegtUeberschneigungVor(BelegungsEintrag belegungsEintrag, BelegungsEintrag belegungsEintragZumVergleichen) {
        if (belegungsEintrag == belegungsEintragZumVergleichen) {
            return false;
        }
        return belegungsEintrag.getZeitraum().ueberschneidet(belegungsEintragZumVergleichen.getZeitraum());
    }
}

