/*
 * Decompiled with CFR 0.152.
 */
package planung;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.regex.Matcher;
import planung.SchichtZeit;
import util.RegexConstants;
import zeit.eintraege.UhrzeitZeitraum;

public final class SchichtZeitFactory {
    private static SchichtZeitFactory instance;

    private SchichtZeitFactory() {
    }

    public static SchichtZeitFactory getInstance() {
        if (instance == null) {
            instance = new SchichtZeitFactory();
        }
        return instance;
    }

    public SchichtZeit parse(String wochentag, String zeitraum) {
        Matcher matcher = RegexConstants.UHRZEITEN_SPANNE.matcher(zeitraum);
        if (matcher.find()) {
            DayOfWeek wchntg;
            LocalTime von = LocalTime.of(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
            LocalTime bis = LocalTime.of(Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
            switch (wochentag.toLowerCase()) {
                case "montag": {
                    wchntg = DayOfWeek.MONDAY;
                    break;
                }
                case "dienstag": {
                    wchntg = DayOfWeek.TUESDAY;
                    break;
                }
                case "mittwoch": {
                    wchntg = DayOfWeek.WEDNESDAY;
                    break;
                }
                case "donnerstag": {
                    wchntg = DayOfWeek.THURSDAY;
                    break;
                }
                case "freitag": {
                    wchntg = DayOfWeek.FRIDAY;
                    break;
                }
                case "samstag": {
                    wchntg = DayOfWeek.SATURDAY;
                    break;
                }
                case "sonntag": {
                    wchntg = DayOfWeek.SUNDAY;
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("der Wert [%s] konnte nicht geparsed werden!", wochentag + zeitraum));
                }
            }
            return SchichtZeit.create(wchntg, UhrzeitZeitraum.create(von, bis));
        }
        throw new RuntimeException(String.format("der Wert [%s] konnte nicht geparsed werden!", wochentag + zeitraum));
    }
}

