package de.fhdw.wtf.context.exception;

/**
 * A class to represent to Supertype to all Exception which can occur in this framework at Runtime.
 */
public class FrameworkException extends RuntimeException {
	
	/**
	 * The exception's serial ID.
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Creates a new Framework Exception with a given message.
	 * 
	 * @param message
	 *            The exception message.
	 */
	public FrameworkException(final String message) {
		super(message);
	}
	
	/**
	 * A method to determine if this exception is a UserException.
	 * 
	 * @return Returns true if this Framework Exception is a User Exception.
	 */
	public boolean isUserException() {
		return false;
	}
	
}
