/*
 * Decompiled with CFR 0.152.
 */
package test.integration;

import de.fhdw.wtf.context.model.Str;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import generated.model.de.fhdw.partner.Haus;
import generated.model.de.fhdw.partner.NatuerlichePerson;
import generated.model.de.fhdw.partner.service.HausService;
import generated.model.de.fhdw.partner.service.PersonService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.integration.IntegrationTestSuperClass;

public abstract class TestAnyTypeCache
extends IntegrationTestSuperClass {
    Str alexr = new Str("Alexander Richter");
    Str bennis = new Str("Benni Scheide");
    Str patrick = new Str("Patrick Fritsche");

    @Before
    public void setUpLocal() throws PersistenceException {
        PersonService personService = this.getPersonService();
        personService.publish();
    }

    protected abstract PersonService getPersonService() throws PersistenceException;

    protected abstract HausService getHausService() throws PersistenceException;

    @Test
    public void testPersonIdWithSameNameNotEquals1() throws PersistenceException {
        PersonService service = this.getPersonService();
        service.publish();
        NatuerlichePerson person1 = service.createPerson(this.alexr);
        NatuerlichePerson person2 = service.createPerson(this.bennis);
        NatuerlichePerson person3 = service.createPerson(person2.getName());
        Long person1Id = person1.getId();
        Long person2Id = person2.getId();
        Long person3Id = person3.getId();
        Assert.assertNotNull((Object)person1Id);
        Assert.assertNotNull((Object)person2Id);
        Assert.assertNotNull((Object)person3Id);
        Assert.assertNotEquals((Object)person1Id, (Object)person2Id);
        Assert.assertNotEquals((Object)person2Id, (Object)person3Id);
    }

    @Test
    public void testCachePersonHaus() throws PersistenceException {
        Haus familienHaus = new Haus(new Str("1A"));
        NatuerlichePerson person1 = new NatuerlichePerson(this.alexr);
        NatuerlichePerson person2 = new NatuerlichePerson(this.patrick);
        person1.setWohnhaft(familienHaus);
        person2.setWohnhaft(familienHaus);
        Long Person1WohnhaftId = person1.getWohnhaft().getId();
        Long Person2WohnhaftId = person2.getWohnhaft().getId();
        Str Person1WohnhaftHausNr = person1.getWohnhaft().getHausNummer();
        Str Person2WohnhaftHausNr = person2.getWohnhaft().getHausNummer();
        Assert.assertEquals((Object)Person1WohnhaftHausNr, (Object)Person2WohnhaftHausNr);
        person1.getWohnhaft().setHausNummer(new Str("11A"));
        Assert.assertEquals((Object)Person1WohnhaftHausNr, (Object)Person2WohnhaftHausNr);
        String objectIdPerson1Haus = Integer.toHexString(System.identityHashCode((Object)person1.getWohnhaft()));
        String objectIdPerson2Haus = Integer.toHexString(System.identityHashCode((Object)person2.getWohnhaft()));
        Assert.assertEquals((Object)Person1WohnhaftId, (Object)Person2WohnhaftId);
        Assert.assertEquals((Object)objectIdPerson1Haus, (Object)objectIdPerson2Haus);
    }

    @Test
    public void testCachePersonService() throws PersistenceException {
        HausService hausService = this.getHausService();
        hausService.publish();
        PersonService personService = this.getPersonService();
        personService.publish();
        Haus familienHaus = hausService.createHaus(new Str("2B"));
        NatuerlichePerson person1 = personService.createPerson(this.alexr);
        NatuerlichePerson person2 = personService.createPerson(this.patrick);
        person1.setWohnhaft(familienHaus);
        person2.setWohnhaft(familienHaus);
        Long Person1WohnhaftId = person1.getWohnhaft().getId();
        Long Person2WohnhaftId = person2.getWohnhaft().getId();
        String objectIdPerson1Haus = Integer.toHexString(System.identityHashCode((Object)person1.getWohnhaft()));
        String objectIdPerson2Haus = Integer.toHexString(System.identityHashCode((Object)person2.getWohnhaft()));
        Assert.assertEquals((Object)Person1WohnhaftId, (Object)Person2WohnhaftId);
        Assert.assertEquals((Object)objectIdPerson1Haus, (Object)objectIdPerson2Haus);
    }
}

