package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.persistence.meta.UserObject;

/**
 * This class represents Maps. It contains 3 valued associations with one value K as key and another value V as value.
 * Values can be accessed via the key.
 * 
 * @param <K>
 *            Type of key elements.
 * @param <V>
 *            Type of value elements.
 */
public class PersistentMap<K extends Anything, V extends Anything> extends MutableMap<K, V> {
	
	/**
	 * Manages the links of this persistent map.
	 */
	private transient PersistentMapWithKeyValueLinks<Anything, Anything> links;
	/**
	 * Name of the underlying database association representing the 0..* relation.
	 */
	public static final String linksAssociationName = "links";
	
	/**
	 * Creates an empty PersistentMap.
	 */
	public PersistentMap() {
		// nothing to do
	}
	
	@Override
	protected void setObject(final UserObject object) {
		super.setObject(object);
		
		final String assocName = PersistentMap.class.getName() + "." + linksAssociationName;
		this.links = new PersistentMapWithKeyValueLinks<>(this.getObject(), assocName);
	}
	
	@Override
	public void put(final K key, final V value) {
		this.links.put(key, value);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public V get(final K key) {
		return (V) this.links.get(key);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public V remove(final K key) {
		return (V) this.links.remove(key);
	}
}
