package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.model.AnyType;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.persistence.meta.UserObject;

/**
 * An interface to represent Key-Value-Pairs of WTF-specific classes or interfaces. Placeholder for AspectJ to inject
 * implementation of PersistentMaps or TransientMaps.
 * 
 * @param <K>
 *            Key
 * @param <V>
 *            Value
 */
public class MutableMap<K extends Anything, V extends Anything> extends AnyType implements Map<K, V> {
	
	/**
	 * This class will be replaced (by an aspect) by PersistentMap or TransientMap.
	 */
	public MutableMap() {
	}
	
	/**
	 * Loads object from database.
	 * 
	 * @param userObject
	 *            The underlying user object.
	 */
	public MutableMap(final UserObject userObject) {
		super(userObject);
	}
	
	@Override
	public void put(final K key, final V value) {
		// nothing to do
	}
	
	@Override
	public V get(final K key) {
		return null;
	}
	
	@Override
	public V remove(final K key) {
		return null;
	}
	
}
