package de.fhdw.wtf.context.model.collections.functors;

import de.fhdw.wtf.context.model.Anything;

/**
 * This interface represents a Function op: T -> (), It has empty choice of Return Types, therefore the function works
 * in place and changes the state of the current element.
 * 
 * @param <T>
 *            A Type T which is a subtype to Anything.
 */
public interface Procedure<T extends Anything> {
	
	/**
	 * This method implements the procedure {@code op}. Note that the state of t might be changed.
	 * 
	 * @param t
	 *            An element of T.
	 */
	void op(T t);
}
