/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.collections.Collection;
import de.fhdw.wtf.context.model.collections.ImmutableCollection;
import de.fhdw.wtf.context.model.collections.MutableCollection;
import de.fhdw.wtf.context.model.collections.functors.EquivalenceRelation;
import de.fhdw.wtf.context.model.collections.functors.Function;
import de.fhdw.wtf.context.model.collections.functors.Operator;
import de.fhdw.wtf.context.model.collections.functors.Predicate;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class ImmutableList<T extends Anything>
implements ImmutableCollection<T> {
    private final List<T> elements = new Vector<T>();

    @Override
    public Collection<T> union(Collection<? extends T> otherCollection) {
        ImmutableList<T> result = new ImmutableList<T>();
        result.elements.addAll(this.elements);
        if (otherCollection instanceof ImmutableCollection) {
            super.addImmutableCollection((ImmutableCollection)otherCollection);
        } else if (otherCollection instanceof MutableCollection) {
            super.addMutableCollection(otherCollection);
        } else {
            throw new FrameworkException("collection not supported");
        }
        return result;
    }

    private void addMutableCollection(Collection<? extends T> otherCollection) {
        for (Anything current : (MutableCollection)otherCollection) {
            this.elements.add(current);
        }
    }

    private void addImmutableCollection(ImmutableCollection<? extends T> otherCollection) {
        if (!otherCollection.isEmpty()) {
            this.elements.add(otherCollection.front());
            this.addImmutableCollection(otherCollection.tail());
        }
    }

    @Override
    public boolean contains(T element) {
        return this.elements.contains(element);
    }

    @Override
    public ImmutableCollection<T> add(T element) {
        ImmutableList<T> result = new ImmutableList<T>();
        result.elements.addAll(this.elements);
        result.elements.add(element);
        return result;
    }

    @Override
    public T front() {
        return (T)((Anything)this.elements.get(0));
    }

    @Override
    public ImmutableCollection<T> tail() {
        ImmutableList<T> result = new ImmutableList<T>();
        result.elements.addAll(this.elements);
        result.elements.remove(0);
        return result;
    }

    @Override
    public ImmutableCollection<T> reverse() {
        ImmutableList<T> result = new ImmutableList<T>();
        ListIterator<T> iterator = this.elements.listIterator(this.elements.size());
        while (iterator.hasPrevious()) {
            Anything current = (Anything)iterator.previous();
            result.elements.add(current);
        }
        return result;
    }

    @Override
    public <U extends Anything> ImmutableCollection<U> map(Function<T, U> function) {
        ImmutableList<T> result = new ImmutableList<T>();
        for (Anything current : this.elements) {
            result.elements.add(function.f(current));
        }
        return result;
    }

    @Override
    public <U extends Anything> U reduce(Operator<T, U> aggregation) {
        U result = aggregation.n();
        for (Anything current : this.elements) {
            result = aggregation.add(result, current);
        }
        return result;
    }

    @Override
    public <U extends Anything> ImmutableCollection<U> reduceEquivalent(EquivalenceRelation<T> equi, Operator<T, U> aggregation) {
        Vector<ImmutableList<T>> between = new Vector<ImmutableList<T>>();
        for (Anything current : this.elements) {
            ImmutableList<Anything> currentList = new ImmutableList<Anything>();
            for (Object innerCurrent : this.elements) {
                if (!equi.equivalent(current, (Anything)innerCurrent)) continue;
                currentList.add((Anything)innerCurrent);
            }
            between.add(currentList);
        }
        ImmutableList<T> result = new ImmutableList<T>();
        while (!between.isEmpty()) {
            ImmutableList current = (ImmutableList)between.get(0);
            between.remove(0);
            Iterator iterator = between.iterator();
            while (iterator.hasNext()) {
                Object innerCurrent;
                innerCurrent = (ImmutableList)iterator.next();
                if (!((ImmutableList)innerCurrent).equals(current)) continue;
                iterator.remove();
            }
            result.elements.add(current.reduce(aggregation));
        }
        return result;
    }

    @Override
    public ImmutableCollection<T> filter(Predicate<T> predicate) {
        ImmutableList<T> result = new ImmutableList<T>();
        for (Anything current : this.elements) {
            if (!predicate.p(current)) continue;
            result.elements.add(current);
        }
        return result;
    }

    @Override
    public T find(Predicate<T> predicate) {
        ImmutableCollection<T> preResult = this.filter(predicate);
        if (preResult.isEmpty()) {
            return null;
        }
        return preResult.front();
    }

    public String toString() {
        return this.elements.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImmutableList)) {
            return false;
        }
        ImmutableList other = (ImmutableList)obj;
        return this.elements.equals(other.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }
}

