package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.model.Anything;

/**
 * An interface to represent Key-Value-Pairs of WTF-specific classes or interfaces.
 * 
 * @param <K>
 *            K is a subtype of Anything and represents the Type of keys.
 * @param <V>
 *            V is a subtype of Anything and represents the Type of values.
 */
public interface Map<K extends Anything, V extends Anything> {
	
	/**
	 * Registers value under key. If a value is already defined for key, it will be overwritten.
	 * 
	 * REQUIRES key != null && value != null
	 * 
	 * @param key
	 *            The key under which the value will be registered.
	 * @param value
	 *            The value to register.
	 */
	void put(K key, V value);
	
	/**
	 * Provides the value which can be found under key.
	 * 
	 * REQUIRES key != null
	 * 
	 * @param key
	 *            The key which references the value.
	 * @return Returns a value or returns null, if the key is not contained in the map.
	 */
	V get(K key);
	
	/**
	 * Deletes the value which can be found under key. The key will still be part of the map, but the value will be
	 * null. If key is not contained in the map nothing happens.
	 * 
	 * REQUIRES key != null
	 * 
	 * @param key
	 *            The key which value shall be removed.
	 */
	// public abstract void reset(K key);
	
	/**
	 * Removes the keyed association to the value, which can be found under the key. If key is not contained in the map
	 * nothing happens.
	 * 
	 * REQUIRES key != null
	 * 
	 * @param key
	 *            The key which value shall be removed.
	 * @return Returns a value or returns null, if the key is not contained in the map.
	 */
	V remove(K key);
	
	/**
	 * Provides a new instance of map with neither keys nor values, but the same Types for keys and values.
	 */
	// public abstract void clear();
}
