/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.core.ObjectFactoryProvider;
import de.fhdw.wtf.context.core.TransactionManager;
import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.context.model.AnyType;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.Int;
import de.fhdw.wtf.context.model.Str;
import de.fhdw.wtf.context.model.collections.Map;
import de.fhdw.wtf.persistence.meta.Link;
import de.fhdw.wtf.persistence.meta.MapLink;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.utils.Tuple;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class PersistentMapWithKeyValueLinks<K extends Anything, V extends Anything>
implements Map<K, V> {
    private final HashMap<K, Tuple<MapLink, V>> mapCache;
    private final String associationName;
    private final UserObject owner;

    public PersistentMapWithKeyValueLinks(UserObject owner, String associationName) {
        this.owner = owner;
        this.associationName = associationName;
        this.mapCache = new HashMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void put(K key, V value) {
        MapLink returnedLink;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (key instanceof Str) {
            String castedKeyString = ((Str)key).toString();
            if (value instanceof Str) {
                Str castedValue = (Str)value;
                returnedLink = TransactionManager.getContext().put(this.owner, this.associationName, castedValue.toString(), castedKeyString);
            } else if (value instanceof Int) {
                Int castedValue = (Int)value;
                returnedLink = TransactionManager.getContext().put(this.owner, this.associationName, castedValue.getVal(), castedKeyString);
            } else {
                if (!(value instanceof AnyType)) throw new FrameworkException("Type to insert is not known");
                AnyType castedValue = (AnyType)value;
                returnedLink = TransactionManager.getContext().put(this.owner, this.associationName, castedValue.getObject(), castedKeyString);
            }
        } else if (key instanceof Int) {
            BigInteger castedKeyObject = ((Int)key).getVal();
            if (value instanceof Str) {
                Str castedValue = (Str)value;
                returnedLink = TransactionManager.getContext().put(this.owner, this.associationName, castedValue.toString(), castedKeyObject);
            } else if (value instanceof Int) {
                Int castedValue = (Int)value;
                returnedLink = TransactionManager.getContext().put(this.owner, this.associationName, castedValue.getVal(), castedKeyObject);
            } else {
                if (!(value instanceof AnyType)) throw new FrameworkException("Type to insert is not known");
                AnyType castedValue = (AnyType)value;
                returnedLink = TransactionManager.getContext().put(this.owner, this.associationName, castedValue.getObject(), castedKeyObject);
            }
        } else {
            if (!(key instanceof AnyType)) throw new FrameworkException("Type to insert is not known");
            UserObject castedKeyObject = ((AnyType)key).getObject();
            if (value instanceof Str) {
                Str castedValue = (Str)value;
                returnedLink = TransactionManager.getContext().put(this.owner, this.associationName, castedValue.toString(), castedKeyObject);
            } else if (value instanceof Int) {
                Int castedValue = (Int)value;
                returnedLink = TransactionManager.getContext().put(this.owner, this.associationName, castedValue.getVal(), castedKeyObject);
            } else {
                if (!(value instanceof AnyType)) throw new FrameworkException("Type to insert is not known");
                AnyType castedValue = (AnyType)value;
                returnedLink = TransactionManager.getContext().put(this.owner, this.associationName, castedValue.getObject(), castedKeyObject);
            }
        }
        this.mapCache.put(key, new Tuple((java.lang.Object)returnedLink, value));
    }

    @Override
    public V get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.mapCache.containsKey(key)) {
            return this.getFromCache(key);
        }
        Collection<Tuple<MapLink, Object>> databaseResult = null;
        if (key instanceof Str) {
            databaseResult = TransactionManager.getContext().get(this.owner, this.associationName, ((Str)key).toString());
        } else if (key instanceof Int) {
            databaseResult = TransactionManager.getContext().get(this.owner, this.associationName, ((Int)key).getVal());
        } else if (key instanceof AnyType) {
            databaseResult = TransactionManager.getContext().get(this.owner, this.associationName, ((AnyType)key).getObject());
        } else {
            throw new FrameworkException("Type to insert is not known");
        }
        Iterator<Tuple<MapLink, Object>> iterator = databaseResult.iterator();
        if (!iterator.hasNext()) {
            this.mapCache.put(key, null);
            return null;
        }
        Tuple<MapLink, Object> firstResult = iterator.next();
        Object firstResultTarget = (Object)firstResult.getSecond();
        Anything result = ObjectFactoryProvider.instance().createObject(firstResultTarget);
        this.mapCache.put(key, new Tuple((java.lang.Object)((MapLink)firstResult.getFirst()), (java.lang.Object)result));
        return this.getFromCache(key);
    }

    private V getFromCache(K key) {
        Tuple<MapLink, V> localTupel = this.mapCache.get(key);
        if (localTupel == null) {
            return null;
        }
        return (V)((Anything)localTupel.getSecond());
    }

    @Override
    public V remove(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Tuple<MapLink, V> toRemoveTuple = this.mapCache.get(key);
        TransactionManager.getContext().unset((Link)toRemoveTuple.getFirst());
        this.mapCache.put(key, null);
        return (V)((Anything)toRemoveTuple.getSecond());
    }
}

