/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.core;

import de.fhdw.wtf.persistence.exception.PersistenceException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Logger {
    private final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:MM:ss:SSSS");
    private static Logger instance = null;

    public static synchronized Logger getInstance() {
        if (instance == null) {
            instance = new Logger();
        }
        return new Logger();
    }

    private Logger() {
    }

    private String getLoggerPrefix(String severity) {
        return "[" + this.format.format(new Date()) + ";" + severity + "] :";
    }

    public void log(PersistenceException e) {
        System.err.println(String.valueOf(this.getLoggerPrefix("Exception")) + e.getMessage());
    }

    public void logError(String message) {
        System.err.println(String.valueOf(this.getLoggerPrefix("Error")) + message);
    }

    public void logInfo(String message) {
        System.out.println(String.valueOf(this.getLoggerPrefix("Info")) + message);
    }
}

