/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.collections.Collection;
import de.fhdw.wtf.context.model.collections.ImmutableCollection;
import de.fhdw.wtf.context.model.collections.ImmutableList;
import de.fhdw.wtf.context.model.collections.MutableCollection;
import de.fhdw.wtf.context.model.collections.MutableList;
import de.fhdw.wtf.context.model.collections.functors.Predicate;
import de.fhdw.wtf.context.model.collections.functors.Procedure;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TransientList<T extends Anything>
extends MutableList<T> {
    private final List<T> elements = new Vector<T>();

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Collection<T> union(Collection<? extends T> otherCollection) {
        if (otherCollection instanceof ImmutableCollection) {
            this.addImmutableCollection((ImmutableCollection)otherCollection);
        } else if (otherCollection instanceof MutableCollection) {
            this.addMutableCollection((MutableCollection)otherCollection);
        } else {
            throw new FrameworkException("Collection type is not supported");
        }
        return this;
    }

    private void addMutableCollection(MutableCollection<? extends T> otherCollection) {
        for (Anything current : otherCollection) {
            this.elements.add(current);
        }
    }

    private void addImmutableCollection(ImmutableCollection<? extends T> otherCollection) {
        if (!otherCollection.isEmpty()) {
            this.elements.add(otherCollection.front());
            this.addImmutableCollection(otherCollection.tail());
        }
    }

    @Override
    public boolean contains(T element) {
        return this.elements.contains(element);
    }

    @Override
    public void insert(T element) {
        this.elements.add(element);
    }

    @Override
    public void apply(Procedure<T> procedure) {
        for (Anything current : this) {
            procedure.op(current);
        }
    }

    @Override
    public void remove(Predicate<T> predicate) {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            Anything current = (Anything)iterator.next();
            if (!predicate.p(current)) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public ImmutableCollection<T> copy() {
        ImmutableCollection<Anything> result = new ImmutableList<Anything>();
        for (Anything current : this.elements) {
            result = result.add(current);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TransientList) {
            TransientList other = (TransientList)obj;
            return this.elements.equals(other.elements);
        }
        if (!(obj instanceof MutableCollection)) {
            return false;
        }
        try {
            MutableCollection other = (MutableCollection)obj;
            for (Anything current : this) {
                if (other.contains(current)) continue;
                return false;
            }
            for (Anything current : other) {
                if (this.contains(current)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        return this.elements.toString();
    }
}

