package de.fhdw.wtf.context.core;

/**
 * Encapsulates methond invocation events.
 */
public class MethodInvokedEvent implements ObserverEvent {
	
	/**
	 * The name of the associated method.
	 */
	private final String methodName;
	
	/**
	 * Creates a MethodInvokedEvent.
	 * 
	 * @param methodName
	 *            The name of the associated method.
	 */
	public MethodInvokedEvent(final String methodName) {
		super();
		this.methodName = methodName;
	}
	
	/**
	 * Returns the name of the associated method.
	 * 
	 * @return The name of the associated method.
	 */
	public String getMethodName() {
		return this.methodName;
	}
	
}
