package de.fhdw.wtf.context.model.collections;

import java.util.concurrent.ConcurrentHashMap;

import de.fhdw.wtf.context.model.Anything;

/**
 * A class to represent Key-Value-Pairs of WTF-specific classes or interfaces.
 * 
 * @param <K>
 *            K is a subtype of Anything and represents the Type of keys.
 * @param <V>
 *            V is a subtype of Anything and represents the Type of values.
 */
public class TransientMap<K extends Anything, V extends Anything> extends MutableMap<K, V> {
	
	/**
	 * The underlying map.
	 */
	private final ConcurrentHashMap<K, V> internalMap;
	
	/**
	 * Creates a TransientMap.
	 */
	public TransientMap() {
		this.internalMap = new ConcurrentHashMap<>();
	}
	
	@Override
	public void put(final K key, final V value) {
		if (key == null || value == null) {
			throw new NullPointerException();
		}
		this.internalMap.put(key, value);
	}
	
	@Override
	public V get(final K key) {
		if (key == null) {
			throw new NullPointerException();
		}
		return this.internalMap.get(key);
	}
	
	@Override
	public V remove(final K key) {
		if (key == null) {
			throw new NullPointerException();
		}
		return this.internalMap.remove(key);
	}
	
	// @Override
	// public void clear() {
	// internalMap = new ConcurrentHashMap<K,V>();
	// }
}
