package de.fhdw.wtf.context.core;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.persistence.facade.IDManager;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.facade.TypeManagerImplementation;
import de.fhdw.wtf.persistence.meta.IntegerValue;
import de.fhdw.wtf.persistence.meta.Link;
import de.fhdw.wtf.persistence.meta.MapLink;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.StringValue;
import de.fhdw.wtf.persistence.meta.UnidirectionalLink;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.meta.UserType;
import de.fhdw.wtf.persistence.utils.Tuple;

/**
 * An implementation of a Context, which can be used in Test cases. It partly simulates the behavior of the persistence
 * layer, so model classes can be tested without needing the database.
 * 
 */
public class TestCaseContext extends Context {
	
	/**
	 * The IDManager which is used to collect Type information. It has to be filled before either from the database or
	 * from a file.
	 */
	private final IDManager manager = IDManager.instance();
	
	/**
	 * The instance Item id will be synthetically created.
	 */
	private static long instanceItemId = 0;
	
	/**
	 * This cache is used to store objects stored via {@link #set} operations.
	 */
	private final Map<UserObject, Map<String, Collection<Tuple<UnidirectionalLink, Object>>>> cache;
	
	/**
	 * The model prefix of the types.
	 */
	private final String modelPrefix;
	
	/**
	 * Creates a TestCaseContext.
	 * 
	 * @param modelPrefix
	 *            The model prefix of the types.
	 */
	public TestCaseContext(final String modelPrefix) {
		this.cache = new HashMap<>();
		this.modelPrefix = modelPrefix;
	}
	
	/**
	 * Returns the next available unique identifier.
	 * 
	 * @return The next available unique identifier.
	 */
	protected static long getInstanceItemId() {
		final long result = instanceItemId;
		instanceItemId++;
		return result;
	}
	
	@Override
	public Collection<UserObject> find(final String associationName, final String value) {
		throw new FrameworkException("A find method for String objects is not yet implemented");
	}
	
	@Override
	public Collection<UserObject> find(final String associationName, final BigInteger value) {
		throw new FrameworkException("A find method for Integer objects is not yet implemented");
	}
	
	@Override
	public Collection<Tuple<UnidirectionalLink, UserObject>> inverseGet(final String associationName,
			final UserObject object) {
		throw new FrameworkException("An inverse get method is not yet implemented");
	}
	
	@Override
	public Collection<Tuple<UnidirectionalLink, Object>> get(final UserObject object, final String associationName) {
		return this.cache.get(object).get(associationName);
	}
	
	@Override
	public Collection<Tuple<MapLink, Object>> get(final UserObject object,
			final String associationName,
			final String key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public Collection<Tuple<MapLink, Object>> get(final UserObject object,
			final String associationName,
			final BigInteger key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public Collection<Tuple<MapLink, Object>> get(final UserObject object,
			final String associationName,
			final UserObject key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public UserObject create(final String typeName) {
		return UserObject.init(
				getInstanceItemId(),
				new UserType(this.manager.findIdForType(typeName.substring(this.modelPrefix.length() + 1)), null,
						false, false));
	}
	
	@Override
	public UnidirectionalLink set(final UserObject object, final String associationName, final String val) {
		final UnidirectionalLink result =
				new UnidirectionalLink(getInstanceItemId(), object, new StringValue(val), null);
		this.put(object, associationName, result);
		return result;
	}
	
	/**
	 * Stores an object/association/link relation in the cache.
	 * 
	 * @param object
	 *            The owner.
	 * @param associationName
	 *            The name of the association.
	 * @param result
	 *            The link.
	 */
	private void put(final UserObject object, final String associationName, final UnidirectionalLink result) {
		if (!this.cache.containsKey(object)) {
			this.cache.put(object, new HashMap<String, Collection<Tuple<UnidirectionalLink, Object>>>());
		}
		this.putInner(this.cache.get(object), associationName, result);
	}
	
	/**
	 * Stores an object/association/link relation in a map that is part of the cache.
	 * 
	 * @param map
	 *            The map for some owner object.
	 * @param associationName
	 *            The name of the association.
	 * @param result
	 *            The link.
	 */
	private void putInner(final Map<String, Collection<Tuple<UnidirectionalLink, Object>>> map,
			final String associationName,
			final UnidirectionalLink result) {
		if (!map.containsKey(associationName)) {
			map.put(associationName, new Vector<Tuple<UnidirectionalLink, Object>>());
		}
		map.get(associationName).add(new Tuple<>(result, result.getTarget()));
	}
	
	@Override
	public UnidirectionalLink set(final UserObject object, final String associationName, final BigInteger val) {
		final UnidirectionalLink result =
				new UnidirectionalLink(getInstanceItemId(), object, new IntegerValue(val), null);
		this.put(object, associationName, result);
		return result;
	}
	
	@Override
	public UnidirectionalLink set(final UserObject object, final String associationName, final UserObject target) {
		final UnidirectionalLink result = new UnidirectionalLink(getInstanceItemId(), object, target, null);
		this.put(object, associationName, result);
		return result;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final UserObject target, final String key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final BigInteger target, final String key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final String target, final String key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final UserObject target,
			final BigInteger key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final BigInteger target,
			final BigInteger key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final String target, final BigInteger key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final UserObject target,
			final UserObject key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final BigInteger target,
			final UserObject key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final String target, final UserObject key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public void commit() {
		// nothing to do
	}
	
	@Override
	public void rollback() {
		// nothing to do
	}
	
	@Override
	public void savePoint() {
		// nothing to do
	}
	
	@Override
	public void rollbackToSavePoint() {
		// nothing to do
	}
	
	@Override
	public void unset(final Link toUnset) {
		final Iterator<Collection<Tuple<UnidirectionalLink, Object>>> iterator =
				this.cache.get(toUnset.getOwner()).values().iterator();
		while (iterator.hasNext()) {
			final Collection<Tuple<UnidirectionalLink, Object>> current = iterator.next();
			final Iterator<Tuple<UnidirectionalLink, Object>> innerIterator = current.iterator();
			while (innerIterator.hasNext()) {
				final Tuple<UnidirectionalLink, Object> innerCurrent = innerIterator.next();
				if (innerCurrent.getFirst().equals(toUnset)) {
					innerIterator.remove();
				}
			}
		}
	}
	
	@Override
	public TypeManager getTypeManager() {
		return TypeManagerImplementation.getInstance();
	}
	
	@Override
	public Collection<UserObject> getObjectsByType(final String typeName) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public UserObject checkout(final long object) {
		// TODO Auto-generated method stub
		return null;
	}
	
}
