package de.fhdw.wtf.persistence.meta;

import java.util.HashSet;
import java.util.Set;

public class Mandant {
	
	private final String id;
	private final String rootPassword;
	private final Set<User> users;
	
	public Mandant(final String id, final String rootPassword) {
		super();
		this.id = id;
		this.rootPassword = rootPassword;
		this.users = new HashSet<>();
	}
	
	public String getId() {
		return this.id;
	}
	
	public String getRootPassword() {
		return this.rootPassword;
	}
	
	public Set<User> getUsers() {
		return this.users;
	}
	
	public void addUser(final User user) {
		this.users.add(user);
	}
	
	@Override
	public boolean equals(final java.lang.Object obj) {
		if (obj instanceof Mandant) {
			final Mandant other = (Mandant) obj;
			return other.getId().equals(this.getId());
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		return this.id.hashCode();
	}
	
}
